//Copyright 2015 Patrik Dürrenberger
//
//This file is part of TTP.
//
//TTP is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//TTP is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

//This code is based on code examples given in
//Williams, A. (2012). C++ Concurrency in Action. Manning.

#include <thread>
#include <queue>
#include <utility>

#ifndef THREADSAFEQUEUE_H
#define THREADSAFEQUEUE_H

template<typename T>
class ThreadsafeQueue{
private:
	mutable std::mutex mut;
	std::queue<T> dataQueue;
	std::condition_variable dataCond;

public:
	ThreadsafeQueue(){}
	void push(T newValue){
		std::lock_guard<std::mutex> lk(mut);
		dataQueue.push(std::move(newValue));
		dataCond.notify_one();
	}
	bool tryPop(T& value){
		std::lock_guard<std::mutex> lk(mut);
		if(dataQueue.empty()){
			return false;
		}
		value = std::move(dataQueue.front());
		dataQueue.pop();
		return true;
	}

	bool empty() const{
		std::lock_guard<std::mutex> lk(mut);
		return dataQueue.empty();
	}
};

#endif
