//Copyright 2015 Patrik Dürrenberger
//
//This file is part of TTP.
//
//TTP is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//TTP is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

//This code is based on code examples given in
//Williams, A. (2012). C++ Concurrency in Action. Manning.

#include <thread>
#include <atomic>
#include <vector>

#include "IDA.h"
#include "JoinThreads.h"
#include "ThreadsafeQueue.h"
#include "HandleSubtreeWithParameters.h"


#ifndef THREADPOOL_H
#define THREADPOOL_H

class ThreadPool{
	Solution* solution;
	std::atomic_bool done;
	ThreadsafeQueue<HandleSubtreeWithParameters > workQueue;
	std::vector<std::thread> threads;
	JoinThreads joiner;
	IDA* ida;
	Limit *fLimit;
	Limit *nextFLimit;
	int currentDepthLimit;
	SubtreeQueue *nextSubtreeQueue;

	void workerThread();

public:
	ThreadPool(Solution* s, IDA* _ida, Limit *fL, Limit *nFL, int cDL, SubtreeQueue *nSQ, int numberOfThreads);
	~ThreadPool();
	template<typename FunctionType>
	void submit(FunctionType f){
		workQueue.push(f);
	}
};

#endif
