//Copyright 2015 Patrik Dürrenberger
//
//This file is part of TTP.
//
//TTP is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//TTP is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

//This code is based on code examples given in
//Williams, A. (2012). C++ Concurrency in Action. Manning.

#include <iostream>

#include "ThreadPool.h"

void ThreadPool::workerThread(){
	while(solution->state == NULL && !done){
		HandleSubtreeWithParameters hswp = HandleSubtreeWithParameters();

		if(workQueue.tryPop(hswp)){
			(ida->*hswp.func)(hswp.counter, *hswp.currentSubtree, *fLimit, *nextFLimit, currentDepthLimit, *nextSubtreeQueue, solution, hswp.counter-1);
		}else{
			std::this_thread::yield();
		}
	}
}

ThreadPool::ThreadPool(Solution* s, IDA* _ida, Limit *fL, Limit *nFL, int cDL, SubtreeQueue *nSQ, int numberOfThreads)
	: solution(s), done(false), joiner(threads), ida(_ida), fLimit(fL), nextFLimit(nFL), currentDepthLimit(cDL), nextSubtreeQueue(nSQ){

	for(int i=0; i<numberOfThreads; ++i){
		threads.push_back(std::thread(&ThreadPool::workerThread, this));
	}
}

ThreadPool::~ThreadPool(){
	const std::chrono::milliseconds dura(50);
	while(!workQueue.empty() && solution->state == NULL){
		std::this_thread::sleep_for(dura);
	}
	done = true;
}
