//Copyright 2015 Patrik Dürrenberger
//
//This file is part of TTP.
//
//TTP is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//TTP is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

#include <stdio.h>

#include "SubtreeQueue.h"

SubtreeQueue::SubtreeQueue(int numberOfSubtrees){
	subtrees = new Subtree*[numberOfSubtrees];
	size = 0;
}

SubtreeQueue::~SubtreeQueue(){
	for(int i=0; i<size; ++i){
		if(subtrees[i] != NULL) delete subtrees[i];
	}
	delete[] subtrees;
}

bool SubtreeQueue::empty(){
	if(size > 0) return false;
	return true;
}
Subtree* SubtreeQueue::top(){
	if(!SubtreeQueue::empty()) return subtrees[size-1];
	return NULL;
}
void SubtreeQueue::pop(){
	if(!SubtreeQueue::empty()){
		--size;
	}
}

void SubtreeQueue::pushRecursive(Subtree* subtree, int comparePosition) {
	if(isWorseSubtree(subtree, subtrees[comparePosition])){
		subtrees[comparePosition + 1] = subtrees[comparePosition];
		if (comparePosition > 0) {
			pushRecursive(subtree, comparePosition-1);
		} else {
			subtrees[comparePosition] = subtree;
		}
	}else{
		subtrees[comparePosition+1] = subtree;
	}
}

void SubtreeQueue::push(Subtree* subtree) {
	std::lock_guard<std::mutex> guard(pushMutex);

	if(size == 0){
		subtrees[size] = subtree;
		++size;
	}else{
		pushRecursive(subtree, size-1);
		++size;
	}
}

//returns true if subtree a is worse compared to subtree b
bool SubtreeQueue::isWorseSubtree(Subtree* a, Subtree* b){
	/*if(a.limit->elitePath == NULL && b.limit->elitePath != NULL){
	   return true;
	}*/
	if(a->limit->depth < b->limit->depth){
		return true;
	}
	if(a->limit->depth == b->limit->depth && a->limit->distance > b->limit->distance){
		   return true;
	}
	/*if(a->limit->distance == b->limit->distance && a->limit->elitePath == NULL){
		return true;
	}*/
	return false;
}
