//Copyright 2015 Patrik Dürrenberger
//
//This file is part of TTP.
//
//TTP is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//TTP is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

#include <iostream>

#include "Subtree.h"

Subtree::Subtree(){
	state = NULL;
	limit = NULL;
	subtreeDepth = 0;
}

Subtree::Subtree(const State &s, const Limit &l, int subtreeDepth){
	state = new State(s);
	limit = new Limit(l);
	this->subtreeDepth = subtreeDepth;
}

Subtree::~Subtree(){
	delete state;
	delete limit;
}

void Subtree::printSubtree(){
	if(state != NULL){
		int numberOfPrintedSubtreeNodes = 0;
		for(int i = 0; i < state->numberOfMatchdays; ++i){
			for(int j = 0; j < state->schedule[i]->numberOfMatches; ++j){
				if(numberOfPrintedSubtreeNodes == subtreeDepth) break;
				if(numberOfPrintedSubtreeNodes != 0){
					std::cout << "\t";
				}
				std::cout << state->schedule[i]->homeTeams[j] << " - " << state->schedule[i]->awayTeams[j];
				++numberOfPrintedSubtreeNodes;
			}
			if(numberOfPrintedSubtreeNodes == subtreeDepth) break;
		}
	}
}
