//Copyright 2015 Patrik Dürrenberger
//
//This file is part of TTP.
//
//TTP is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//TTP is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

#ifndef SUBSET_H
#define SUBSET_H
struct Subset{
private:
	bool* team;
	int minDistance;
	int size;
	int maxLength;
	bool critical;
	int numberOfTeams;

public:
	int* teams;

	Subset(){}
	Subset(int U, int numberOfTeams);
	Subset(const Subset& sub);
	bool operator!=(const Subset &sub) const;
	~Subset();

	bool push_back(int team);
	int getSize() const;
	bool teamInSubset(int team) const;
	void setCritical();
	void print() const;
	bool doStep(int &counter, int currentTeam);
	int getMinDistance();
	void setMinDistance(int minDistance);
	bool isCritical();
	int getTeamArrayAddress();
	int getTeam(int i);

private:
	void reset();
};

struct SubsetContainer{
	Subset** subsets;
	int nextFreeIndex;
	int length;
	int in1, in2, in3;

	SubsetContainer(){}
	SubsetContainer(int l);
	~SubsetContainer();

	bool push_ordered(Subset* subset);
	bool push_back(Subset* subset);
	int size();
	Subset* at(int i);
};
#endif
