//Copyright 2015 Patrik Dürrenberger
//
//This file is part of TTP.
//
//TTP is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//TTP is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

#include <stdio.h>
#include <iostream>

#include "Subset.h"

//for method doStep
#define CHECK_BIT(var,pos) ((var) & (1<<(pos)))

Subset::Subset(int U, int NoT){
	team = new bool[NoT];
	for(int i=0; i<NoT; ++i){
		team[i] = false;
	}
	teams = new int[U];
	size = 0;
	maxLength = U;
	critical = false;
	minDistance = -1;
	numberOfTeams = NoT;
}

Subset::Subset(const Subset& sub){
	maxLength = sub.maxLength;
	size = sub.size;
	minDistance = sub.minDistance;
	numberOfTeams = sub.numberOfTeams;
	team = new bool[numberOfTeams];
	teams = new int[maxLength];
	for(int i=0; i<numberOfTeams; ++i){
		if(i < maxLength) teams[i] = sub.teams[i];
		team[i] = sub.team[i];
	}
	critical = sub.critical;

}

bool Subset::operator!=(const Subset &sub) const{
	if(getSize() != sub.getSize()) return true;
	for(int i=0; i<sub.getSize(); ++i){
		if(teamInSubset(i) != sub.teamInSubset(i)){
			return true;
		}
	}
	return false;
}

Subset::~Subset(){
	delete[] team;
	delete[] teams;
}

void Subset::reset(){
	size = 0;
	for(int i=0; i<numberOfTeams; ++i){
		team[i] = false;
	}
	delete[] teams;
	teams = new int[maxLength];
}

bool Subset::doStep(int &counter, int currentTeam){
	reset();
	while(true){
		//check if all subsets have been generated
		if(counter < (1<<numberOfTeams)){
			//if current team is not in the subset corresponding to this counter
			if(!CHECK_BIT(counter,currentTeam)){
				//loop over all teams and see if they belong into the current subset. If they do add them to the subset.
				for(int j = 0; j < numberOfTeams; ++j){
					if(CHECK_BIT(counter,j)){
						push_back(j);
					}
				}
				return true;
			}else{
				++(counter);
			}
		}else{
			return false;
		}
	}
}

bool Subset::teamInSubset(int t) const{
	return team[t];
}

bool Subset::push_back(int t){
	if(size < maxLength){
		team[t] = true;
		teams[size] = t;
		++size;
		return true;
	}else{
		return false;
	}
}

int Subset::getTeam(int index){
	if(index<size){
		return teams[index];
	}
	return -1;
}

int Subset::getSize() const{
	return size;
}

void Subset::setCritical(){
	critical = true;
}

int Subset::getMinDistance(){
	return minDistance;
}

void Subset::setMinDistance(int minDistance){
	this->minDistance = minDistance;
}

bool Subset::isCritical(){
	return critical;
}

void Subset::print() const{
	std::cout << "(";
	for(int i=0; i<size; ++i){
		std::cout << teams[i];
		if(i < size-1){
			std::cout << ",";
		}
	}
	if(critical) std::cout << "!";
	std::cout << ")";
}

SubsetContainer::SubsetContainer(int l){
	subsets = new Subset*[l];
	nextFreeIndex = 0;
	length = l;
	in1 = 0;
	in2 = 0;
	in3 = 0;
}

SubsetContainer::~SubsetContainer(){
	for(int i=0; i < size(); ++i){
		delete subsets[i];
	}
	delete[] subsets;
}

bool SubsetContainer::push_back(Subset* subset){
	if(nextFreeIndex < length){
		subsets[nextFreeIndex] = subset;
		++nextFreeIndex;
		return true;
	}else{
		return false;
	}
}

bool SubsetContainer::push_ordered(Subset* subset){
	if(subset->getSize() == 1){
		push_back(subset);
		//set indexes
		++in1;
	}else if(subset->getSize() == 2){
		if(in1 == 0){
			push_back(subset);
		}else{
			push_back(subsets[in3+in2]);
			subsets[in3+in2] = subset;
		}
		//set indexes
		++in2;
	}else if(subset->getSize() == 3){
		if(in1+in2 == 0){
			push_back(subset);
		}else{
			push_back(subsets[in3+in2]);
			subsets[in3+in2] = subsets[in3];
			subsets[in3] = subset;
		}
		//set indexes
		++in3;
	}
	return true;
}

int SubsetContainer::size(){
	return nextFreeIndex;
}

Subset* SubsetContainer::at(int i){
	if(i < length){
		return subsets[i];
	}else{
		return NULL;
	}
}
