//Copyright 2015 Patrik Dürrenberger
//
//This file is part of TTP.
//
//TTP is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//TTP is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

#include <set>
#include <string>

#include "DistanceMatrix.h"

#ifndef STATE_H
#define STATE_H

struct Matchday{
	int* opponentOfTeam;
	int numberOfTeams;
	int numberOfMatches;
	int numberOfScheduledMatches;
	bool* triedElitePath;
	int* homeTeams;
	int* awayTeams;
	std::set<int> matchdaySet;

	Matchday(void){}
	Matchday(int numberOfTeams);
	Matchday(const Matchday* m);
	~Matchday();

	bool equalTo(const Matchday& m);
	std::string printUnequal(const Matchday& m);
	std::string print();
	int getCurrentHomeTeam(int currentMatch);
	int getCurrentAwayTeam(int currentMatch);
	void addMatch(int home, int away);
	void deleteCurrentMatch();
	bool hasPlayedAway(int team);
	bool hasPlayedHome(int team);
	int hasPlayedAgainst(int team);
	void printAllScheduledMatches(DistanceMatrix* dists);
};

struct State{
	Matchday** schedule;
	int numberOfMatchdays;
	int numberOfScheduledMatchdays;
	bool** stillHasToPlayAway;
	int traveledDistance;
	int* timesPlayedHome;
	int* timesPlayedAway;
	int* numberOfConsecutiveHomeGames;
	int* numberOfConsecutiveAwayGames;
	bool** matchdayWasPlayedByTeam;
	int* lastTeamPlayed;
	int numberOfTeams;
	DistanceMatrix* distMatrix;
	int depth;

	State(void){}
	State(const State &s);
	~State();

	void print();
	void printUnequal(const State& s);
	bool equalTo(const State& s);
	static State* makeRootState(DistanceMatrix* distMatrix);
	//Index* toIndex(int currentTeam, int upperBound);
};

#endif
