//Copyright 2015 Patrik Dürrenberger
//
//This file is part of TTP.
//
//TTP is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//TTP is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

#include "State.h"
#include <iostream>
#include <sstream>

Matchday::Matchday(int numberOfTeams){
	numberOfMatches = numberOfTeams/2;
	opponentOfTeam = new int[numberOfTeams];
	triedElitePath = new bool[numberOfMatches];
	numberOfScheduledMatches = 0;
	this->numberOfTeams = numberOfTeams;
	homeTeams = new int[numberOfMatches];
	awayTeams = new int[numberOfMatches];
	for(int j=0; j < numberOfTeams; ++j){
		opponentOfTeam[j] = -1;
		if(j < numberOfMatches){
			triedElitePath[j] = false;
		}
	}
}

Matchday::Matchday(const Matchday* m){
	numberOfTeams = m->numberOfTeams;
	numberOfMatches = m->numberOfMatches;
	numberOfScheduledMatches = m->numberOfScheduledMatches;
	opponentOfTeam = new int[numberOfTeams];
	triedElitePath = new bool[numberOfMatches];
	homeTeams = new int[numberOfMatches];
	awayTeams = new int[numberOfMatches];
	for(int i=0; i < numberOfTeams; ++i){
		opponentOfTeam[i] = m->opponentOfTeam[i];
		if(i < numberOfMatches){
			homeTeams[i] = m->homeTeams[i];
			awayTeams[i] = m->awayTeams[i];
			triedElitePath[i] = m->triedElitePath[i];
		}
	}
}

bool Matchday::equalTo(const Matchday& m){
	if(numberOfTeams != m.numberOfTeams) return false;
	if(numberOfMatches != m.numberOfMatches) return false;
	int bigger = numberOfScheduledMatches;
	if(numberOfScheduledMatches != m.numberOfScheduledMatches){
		if(m.numberOfScheduledMatches > bigger) bigger = m.numberOfScheduledMatches;
		return false;
	}
	for(int i=0; i < numberOfTeams; ++i){
		if(opponentOfTeam[i] != m.opponentOfTeam[i]) return false;
		if(i < bigger){
			if(homeTeams[i] != m.homeTeams[i]) return false;
			if(awayTeams[i] != m.awayTeams[i]) return false;
			if(triedElitePath[i] != m.triedElitePath[i]) return false;
		}
	}
	return true;
}

std::string Matchday::printUnequal(const Matchday& m){
	std::stringstream returnMessage;
	if(numberOfTeams != m.numberOfTeams){
		returnMessage << "numberOfTeams is unequal: " << numberOfTeams << " and " << m.numberOfTeams << std::endl;
	}
	if(numberOfMatches != m.numberOfMatches){
		returnMessage << "numberOfMatches is unequal: " << numberOfMatches << " and " << m.numberOfMatches << std::endl;
	}
	int bigger = numberOfScheduledMatches;
	if(numberOfScheduledMatches != m.numberOfScheduledMatches){
		if(m.numberOfScheduledMatches > bigger) bigger = m.numberOfScheduledMatches;
		returnMessage << "numberOfScheduledMatches is unequal: " << numberOfScheduledMatches << " and " << m.numberOfScheduledMatches << std::endl;
	}
	for(int i=0; i < numberOfTeams; ++i){
		if(opponentOfTeam[i] != m.opponentOfTeam[i]){
			returnMessage << "opponentOfTeam " << i << " is unequal: " << opponentOfTeam[i] << " and " << m.opponentOfTeam[i] << std::endl;
		}
		if(i < bigger){
			if(homeTeams[i] != m.homeTeams[i]){
				returnMessage << "homeTeams " << i << " is unequal: " << homeTeams[i] << " and " << m.homeTeams[i] << std::endl;
			}
			if(awayTeams[i] != m.awayTeams[i]){
				returnMessage << "awayTeams " << i << " is unequal: " << awayTeams[i] << " and " << m.awayTeams[i] << std::endl;
			}
			if(triedElitePath[i] != m.triedElitePath[i]){
				returnMessage << "triedElitePath " << i << " is unequal: " << triedElitePath[i] << " and " << m.triedElitePath[i] << std::endl;
			}
		}
	}
	return returnMessage.str();
}

std::string Matchday::print(){
	std::stringstream returnMessage;
	returnMessage << "numberOfTeams is: " << numberOfTeams << std::endl;
	returnMessage << "numberOfMatches is: " << numberOfMatches << std::endl;
	returnMessage << "numberOfScheduledMatches is: " << numberOfScheduledMatches << std::endl;
	for(int i=0; i < numberOfTeams; ++i){
		returnMessage << "opponentOfTeam " << i << " is: " << opponentOfTeam[i] << std::endl;
		if(i < numberOfScheduledMatches){
			returnMessage << "homeTeams " << i << " is: " << homeTeams[i] << std::endl;
			returnMessage << "awayTeams " << i << " is: " << awayTeams[i] << std::endl;
			returnMessage << "triedElitePath " << i << " is: " << triedElitePath[i] << std::endl;
		}
	}
	return returnMessage.str();
}

Matchday::~Matchday(){
	delete[] opponentOfTeam;
	delete[] triedElitePath;
	delete[] homeTeams;
	delete[] awayTeams;
}

int Matchday::getCurrentHomeTeam(int currentMatch){
	if(currentMatch < 0) return -1;
	return homeTeams[currentMatch];
}

int Matchday::getCurrentAwayTeam(int currentMatch){
	return awayTeams[currentMatch];
}

void Matchday::addMatch(int home, int away){
	opponentOfTeam[home] = away;
	homeTeams[numberOfScheduledMatches] = home;
	awayTeams[numberOfScheduledMatches] = away;
}

void Matchday::deleteCurrentMatch(){
	opponentOfTeam[homeTeams[numberOfScheduledMatches]] = -1;
}

bool Matchday::hasPlayedAway(int team){
	if(opponentOfTeam[team] < 0){
		return true;
	}else{
		return false;
	}
}

bool Matchday::hasPlayedHome(int team){
	return !hasPlayedAway(team);
}

int Matchday::hasPlayedAgainst(int team){
	if(opponentOfTeam[team] < 0){
		for(int i = 0; i < numberOfTeams; ++i){
			if(opponentOfTeam[i] == team){
				return i;
			}
		}
		std::cout << "should not happen (in Matchday.hasPlayedAgainst)" << std::endl;
		return -1;
	}else{
		return opponentOfTeam[team];
	}
	std::cout << "should not happen (in Matchday.hasPlayedAgainst)" << std::endl;
	return -1;
}

void Matchday::printAllScheduledMatches(DistanceMatrix* dists){
	for(int i = 0; i < numberOfTeams; ++i){
		if(opponentOfTeam[i] >= 0){
			std::cout << dists->labels[i] << " - " << dists->labels[opponentOfTeam[i]] << std::endl;
		}
	}
}

State::State(const State &s){
	depth = s.depth;
	distMatrix = s.distMatrix;
	numberOfMatchdays = s.numberOfMatchdays;
	numberOfScheduledMatchdays = s.numberOfScheduledMatchdays;
	traveledDistance = s.traveledDistance;
	numberOfTeams = s.numberOfTeams;
	schedule = new Matchday*[numberOfMatchdays];
	for(int i=0; i < numberOfMatchdays; ++i){
		schedule[i] = new Matchday(s.schedule[i]);
	}
	stillHasToPlayAway = new bool*[numberOfTeams];
	timesPlayedHome = new int[numberOfTeams];
	timesPlayedAway = new int[numberOfTeams];
	lastTeamPlayed = new int[numberOfTeams];
	numberOfConsecutiveHomeGames = new int[numberOfTeams];
	numberOfConsecutiveAwayGames = new int[numberOfTeams];
	for(int i=0; i < (numberOfTeams); ++i){
		lastTeamPlayed[i] = s.lastTeamPlayed[i];
		timesPlayedHome[i] = s.timesPlayedHome[i];
		timesPlayedAway[i] = s.timesPlayedAway[i];
		numberOfConsecutiveHomeGames[i] = s.numberOfConsecutiveHomeGames[i];
		numberOfConsecutiveAwayGames[i] = s.numberOfConsecutiveAwayGames[i];
		stillHasToPlayAway[i] = new bool[numberOfTeams];
		for(int j=0; j < numberOfTeams; ++j){
			stillHasToPlayAway[i][j] = s.stillHasToPlayAway[i][j];
		}
	}
	matchdayWasPlayedByTeam = new bool*[numberOfMatchdays];
	for(int i=0; i < numberOfMatchdays; ++i){
		matchdayWasPlayedByTeam[i] = new bool[numberOfTeams];
		for(int j=0; j < numberOfTeams; ++j){
			matchdayWasPlayedByTeam[i][j] = s.matchdayWasPlayedByTeam[i][j];
		}
	}
}

State::~State(){
	for(int i = 0; i < numberOfTeams; ++i){
		delete[] stillHasToPlayAway[i];
	}
	delete[] stillHasToPlayAway;
	for(int i=0; i < numberOfMatchdays; ++i){
		delete schedule[i];
		delete[] matchdayWasPlayedByTeam[i];
	}
	delete[] matchdayWasPlayedByTeam;
	delete[] timesPlayedHome;
	delete[] timesPlayedAway;
	delete[] lastTeamPlayed;
	delete[] numberOfConsecutiveHomeGames;
	delete[] numberOfConsecutiveAwayGames;
	delete[] schedule;
}

bool State::equalTo(const State& s){
	if(numberOfMatchdays != s.numberOfMatchdays) return false;
	if(numberOfScheduledMatchdays != s.numberOfScheduledMatchdays) return false;
	if(traveledDistance != s.traveledDistance) return false;
	if(numberOfTeams != s.numberOfTeams) return false;
	for(int i=0; i < numberOfMatchdays; ++i){
		if(!schedule[i]->equalTo(*s.schedule[i])) return false;
	}
	for(int i=0; i < (numberOfTeams); ++i){
		if(lastTeamPlayed[i] != s.lastTeamPlayed[i]) return false;
		if(timesPlayedHome[i] != s.timesPlayedHome[i]) return false;
		if(numberOfConsecutiveHomeGames[i] != s.numberOfConsecutiveHomeGames[i]) return false;
		if(numberOfConsecutiveAwayGames[i] != s.numberOfConsecutiveAwayGames[i]) return false;
		for(int j=0; j < numberOfTeams; ++j){
			if(stillHasToPlayAway[i][j] != s.stillHasToPlayAway[i][j]) return false;
		}
	}
	for(int i=0; i < numberOfMatchdays; ++i){
		for(int j=0; j < numberOfTeams; ++j){
			if(matchdayWasPlayedByTeam[i][j] != s.matchdayWasPlayedByTeam[i][j]) return false;
		}
	}
	return true;
}

void State::printUnequal(const State& s){
	if(numberOfMatchdays != s.numberOfMatchdays){
		std::cout << "numberOfMatchdays is unequal: " << numberOfMatchdays << " and " << s.numberOfMatchdays << std::endl;
	}
	if(numberOfScheduledMatchdays != s.numberOfScheduledMatchdays){
		std::cout << "numberOfScheduledMatchdays is unequal: " << numberOfScheduledMatchdays << " and " << s.numberOfScheduledMatchdays << std::endl;
	}
	if(traveledDistance != s.traveledDistance){
		std::cout << "traveledDistance is unequal: " << traveledDistance << " and " << s.traveledDistance << std::endl;
	}
	if(numberOfTeams != s.numberOfTeams){
		std::cout << "numberOfTeams is unequal: " << numberOfTeams << " and " << s.numberOfTeams << std::endl;
	}
	for(int i=0; i < numberOfMatchdays; ++i){
		std::string answer = schedule[i]->printUnequal(*s.schedule[i]);
		if(answer.length() > 0){
			std::cout << "For matchday " << i << ":" << std::endl << answer;
		}
	}
	for(int i=0; i < (numberOfTeams); ++i){
		if(lastTeamPlayed[i] != s.lastTeamPlayed[i]){
			std::cout << "lastTeamPlayed for team " << i << " is unequal: " << lastTeamPlayed[i] << " and " << s.lastTeamPlayed[i] << std::endl;
		}
		if(timesPlayedHome[i] != s.timesPlayedHome[i]){
			std::cout << "timesPlayedHome for team " << i << " is unequal: " << timesPlayedHome[i] << " and " << s.timesPlayedHome[i] << std::endl;
		}
		if(numberOfConsecutiveHomeGames[i] != s.numberOfConsecutiveHomeGames[i]){
			std::cout << "numberOfConsecutiveHomeGames for team " << i << " is unequal: " << numberOfConsecutiveHomeGames[i] << " and " << s.numberOfConsecutiveHomeGames[i] << std::endl;
		}
		if(numberOfConsecutiveAwayGames[i] != s.numberOfConsecutiveAwayGames[i]){
			std::cout << "numberOfConsecutiveAwayGames for team " << i << " is unequal: " << numberOfConsecutiveAwayGames[i] << " and " << s.numberOfConsecutiveAwayGames[i] << std::endl;
		}
		for(int j=0; j < numberOfTeams; ++j){
			if(stillHasToPlayAway[i][j] != s.stillHasToPlayAway[i][j]){
				std::cout << "team " << i << " stillHasToPlayAway team " << j << " is unequal: " << stillHasToPlayAway[i][j] << " and " << s.stillHasToPlayAway[i][j] << std::endl;
			}
		}
	}
	for(int i=0; i < numberOfMatchdays; ++i){
		for(int j=0; j < numberOfTeams; ++j){
			if(matchdayWasPlayedByTeam[i][j] != s.matchdayWasPlayedByTeam[i][j]){
				std::cout << "Matchday " << i << " wasPlayedByTeam " << j << " is unequal: " << matchdayWasPlayedByTeam[i][j] << " and " << s.matchdayWasPlayedByTeam[i][j] << std::endl;
			}
		}
	}
}

void State::print(){
	std::cout << "numberOfMatchdays is: " << numberOfMatchdays << std::endl;
	std::cout << "numberOfScheduledMatchdays is: " << numberOfScheduledMatchdays << std::endl;
	std::cout << "traveledDistance is: " << traveledDistance << std::endl;
	std::cout << "numberOfTeams is: " << numberOfTeams << std::endl;
	for(int i=0; i < numberOfMatchdays; ++i){
		std::string answer = schedule[i]->print();
		if(answer.length() > 0){
			std::cout << "For matchday " << i << ":" << std::endl << answer;
		}
	}
	for(int i=0; i < (numberOfTeams); ++i){
		std::cout << "lastTeamPlayed for team " << i << " is: " << lastTeamPlayed[i] << std::endl;
		std::cout << "timesPlayedHome for team " << i << " is: " << timesPlayedHome[i] << std::endl;
		std::cout << "numberOfConsecutiveHomeGames for team " << i << " is: " << numberOfConsecutiveHomeGames[i] << std::endl;
		std::cout << "numberOfConsecutiveAwayGames for team " << i << " is: " << numberOfConsecutiveAwayGames[i] << std::endl;
		for(int j=0; j < numberOfTeams; ++j){
			std::cout << "team " << i << " stillHasToPlayAway team " << j << " is: " << stillHasToPlayAway[i][j] << std::endl;
		}
	}
	for(int i=0; i < numberOfMatchdays; ++i){
		for(int j=0; j < numberOfTeams; ++j){
			std::cout << "Matchday " << i << " wasPlayedByTeam " << j << " is: " << matchdayWasPlayedByTeam[i][j] << std::endl;
		}
	}
}

State* State::makeRootState(DistanceMatrix* distMatrix){
	State* state = new State();

	//make root state with schedule of empty matchdays
	state->depth = -1;
	state->numberOfMatchdays = (distMatrix->numberOfTeams-1) + (distMatrix->numberOfTeams-1);
	state->numberOfScheduledMatchdays = 0;

	state->distMatrix = distMatrix;

	state->schedule = new Matchday*[state->numberOfMatchdays];
	for(int i=0; i < state->numberOfMatchdays; ++i){
		state->schedule[i] = new Matchday(distMatrix->numberOfTeams);
	}

	state->stillHasToPlayAway = new bool*[distMatrix->numberOfTeams];
	state->timesPlayedHome = new int[distMatrix->numberOfTeams];
	state->timesPlayedAway = new int[distMatrix->numberOfTeams];
	state->lastTeamPlayed = new int[distMatrix->numberOfTeams];
	state->numberOfConsecutiveHomeGames = new int[distMatrix->numberOfTeams];
	state->numberOfConsecutiveAwayGames = new int[distMatrix->numberOfTeams];
	for(int i=0; i < (distMatrix->numberOfTeams); ++i){
		state->lastTeamPlayed[i] = -1;
		state->timesPlayedHome[i] = 0;
		state->timesPlayedAway[i] = 0;
		state->numberOfConsecutiveHomeGames[i] = 0;
		state->numberOfConsecutiveAwayGames[i] = 0;
		state->stillHasToPlayAway[i] = new bool[distMatrix->numberOfTeams];
		for(int j=0; j < distMatrix->numberOfTeams; ++j){
			//set every team j that team i has still to play to true (initially: only i=j => false)
			if(i != j){
				state->stillHasToPlayAway[i][j] = true;
			}else{
				state->stillHasToPlayAway[i][j] = false;
			}
		}
	}

	state->matchdayWasPlayedByTeam = new bool*[state->numberOfMatchdays];
	for(int i=0; i < state->numberOfMatchdays; ++i){
		state->matchdayWasPlayedByTeam[i] = new bool[distMatrix->numberOfTeams];
		for(int j=0; j < distMatrix->numberOfTeams; ++j){
			state->matchdayWasPlayedByTeam[i][j] = false;
		}

	}

	state->traveledDistance = 0;
	state->numberOfTeams = distMatrix->numberOfTeams;
	return state;
}

/*Index* State::toIndex(int currentTeam, int upperBound){
	int remainingAwayGames = numberOfMatchdays/2 - timesPlayedAway[currentTeam];
	int remainingHomeGames = numberOfMatchdays/2 - timesPlayedHome[currentTeam];
	Subset* teamsToPlayAway = new Subset(numberOfTeams-1, numberOfTeams);
	for(int i=0; i<numberOfTeams; ++i){
		if(stillHasToPlayAway[currentTeam][i]){
			teamsToPlayAway->push_back(i);
		}
	}
	int nmbOfConsevutiveAwayGames = numberOfConsecutiveAwayGames[currentTeam];
	int lastTeamPlayedAway = -1;
	if(numberOfConsecutiveAwayGames[currentTeam] > 0){
		lastTeamPlayedAway = lastTeamPlayed[currentTeam];
	}
	return new Index(remainingAwayGames, remainingHomeGames, teamsToPlayAway, nmbOfConsevutiveAwayGames,
			lastTeamPlayedAway, numberOfTeams, currentTeam, upperBound);
}*/
