//Copyright 2015 Patrik Dürrenberger
//
//This file is part of TTP.
//
//TTP is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//TTP is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

#include <iostream>
#include <fstream>
#include <cstdlib>

#include "DistanceMatrix.h"
#include "Parser.h"

using namespace std;

void Parser::printData(DistanceMatrix d){
	//printLabels
	for(int i = 0; i < d.numberOfTeams; i++){
		cout << d.labels[i] << ' ';
	}
	cout << '\n';

	//print distances
	for(int i = 0; i < d.numberOfTeams; i++){
		for(int j = 0; j < d.numberOfTeams; j++){
			cout << d.distances[i][j] << " ";
		}
		cout << '\n';
	}
}

DistanceMatrix* Parser::getData(const char* path){
	ifstream table (path, std::ifstream::in);
	string line, linecpy, linecpy2;
	int row = 0, col = 0;;
	DistanceMatrix* d = new DistanceMatrix();

	if(table.is_open()){
		while(getline(table,line) || !linecpy.empty()){
			row++;
			col = 0;
			if(row == 1){
				linecpy = line;
			}else{
				linecpy2 = line;
				line = linecpy;
				linecpy = linecpy2;
			}
			if(!line.empty()){
				line.resize(line.find_last_not_of(' ') + 1); //crop of all unnecessary spaces at the end of the line
			}
			while(!line.empty()){
			  if(row == 1){
				  col++;
			  }else{
				  col++;
				  d->distances[row-2][col-1] = atoi(line.substr(0,line.find_first_of(' ')).data());
			  }
			  if(line.find(' ') != string::npos){ //if not reached the last number of the line
				  line = line.substr(line.find_first_of(' '));
				  line = line.substr(line.find_first_not_of(' '));
			  }else{
				  line = "";
			  }
			}
			  if(row == 1){
				  d->numberOfTeams = col;
				  d->distances = new int* [col];
				  for (int i = 0; i < col; i++){
					  d->distances[i] = new int[col] {};
				  }
			  }
		}
		table.close();
	}else{
		cout << "Unable to open file" << '\n';
	}
	d->setSymmetry();

	return d;
}

void Parser::addLabels(DistanceMatrix* d, const char* path){
	const int MAX_LABEL_LENGTH = 50;
	ifstream labels (path, std::ifstream::in);
	string line;
	d->labels = new string[d->numberOfTeams];
	int counter = 0;

	if(labels.is_open()){
		while(getline(labels,line) && counter < d->numberOfTeams){ //while there is still a label to use
			if(line.length() <= MAX_LABEL_LENGTH && counter < d->numberOfTeams){
				d->labels[counter] = line;
			}
			counter++;
		}
	}else{
		cout << "Unable to open file (labels)" << '\n';
	}
	}
