//Copyright 2015 Patrik Dürrenberger
//
//This file is part of TTP.
//
//TTP is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//TTP is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

#include <mutex>

#include "State.h"

#ifndef LIMIT_H
#define LIMIT_H

class ElitePath{
public:
	Matchday** schedule;
	int numberOfMatchdays;

	ElitePath(const State &state);
	ElitePath(const ElitePath &ep);
	~ElitePath();
};

struct Limit{
	int distance;
	int depth;
	ElitePath* elitePath;


	Limit(){}
	Limit(int dist);
	Limit(int dist, int dep);
	Limit(int dist, int dep, ElitePath* ep);
	Limit(const Limit &l);
	~Limit();

	void update(int f_n, int d, ElitePath* state, bool applyElitePaths);
};

#endif
