//Copyright 2015 Patrik Dürrenberger
//
//This file is part of TTP.
//
//TTP is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//TTP is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

#include <stdio.h>

#include "Limit.h"

Limit::Limit(int dist){
	distance = dist;
	depth = 0;
	elitePath = NULL;
}

Limit::Limit(int dist, int dep){
	distance = dist;
	depth = dep;
	elitePath = NULL;
}

Limit::Limit(int dist, int dep, ElitePath* ep){
	distance = dist;
	depth = dep;
	elitePath = ep;
}

Limit::Limit(const Limit &l){
	distance = l.distance;
	depth = l.depth;
	if(l.elitePath != NULL){
		elitePath = new ElitePath(*(l.elitePath));
	}else{
		elitePath = NULL;
	}
}

Limit::~Limit(){
	if(elitePath != NULL){
		delete elitePath;
	}
}

void Limit::update(int f_n, int d, ElitePath* ep, bool applyElitePaths){
	distance = f_n;
	depth = d;
	if(applyElitePaths){
		if(elitePath != NULL){
			delete elitePath;
		}
		if(ep != NULL){
			elitePath = ep;
		}else{
			elitePath = NULL;
		}
	}else{
		delete ep;
		elitePath = NULL;
	}
}

ElitePath::ElitePath(const State &state){
	numberOfMatchdays = state.numberOfMatchdays;
	schedule = new Matchday*[numberOfMatchdays];
	for(int i=0; i<numberOfMatchdays; ++i){
		schedule[i] = new Matchday(state.schedule[i]);
	}
}

ElitePath::ElitePath(const ElitePath &ep){
	numberOfMatchdays = ep.numberOfMatchdays;
	schedule = new Matchday*[numberOfMatchdays];
	for(int i=0; i<numberOfMatchdays; ++i){
		schedule[i] = new Matchday(ep.schedule[i]);
	}
}

ElitePath::~ElitePath(){
	if(!schedule || !*schedule) return;
	for(int i=0; i<numberOfMatchdays; ++i){
		delete schedule[i];
	}
	delete[] schedule;
}
