//Copyright 2015 Patrik Dürrenberger
//
//This file is part of TTP.
//
//TTP is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//TTP is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

//This code is based on code examples given in
//Williams, A. (2012). C++ Concurrency in Action. Manning.

#include <thread>

#ifndef JOINTHREADS_H
#define JOINTHREADS_H

class JoinThreads{
	std::vector<std::thread>& threads;
public:
	explicit JoinThreads(std::vector<std::thread>& threads_) :
		threads(threads_){}
	~JoinThreads(){
		for(int i=0; i < threads.size(); ++i){
			if(threads[i].joinable()){
				threads[i].join();
			}
		}
	}
};

#endif
