//Copyright 2015 Patrik Dürrenberger
//
//This file is part of TTP.
//
//TTP is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//TTP is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

#include "State.h"
#include "findMinTravelDistance.h"
#include "DisjointPatternDatabase/Index.h"
#include "DisjointPatternDatabase/PatternDatabase.h"


#ifndef ILB_H
#define ILB_H
class ILB{
private:
	const int lowerBound, upperBound;
	const int numberOfTeams;
	int numberOfThreads;
	int*** previousMinTravelDistance;
	const int totalNumberOfGames;
	const PatternDatabase** disjointPatternDatabase;
	FindMinTravelDistance* minTravelDistanceFinder;

public:
	ILB(DistanceMatrix* d, int lowerBound, int upperBound, int numberOfTotalGames, int numberOfThreads);
	~ILB();
	int h(const State &state, const int& threadNumber) const;
	void setNumberOfThreads(int nOT);

private:
	const PatternDatabase** createDisjointPatternDatabase(DistanceMatrix* d);
	void resetPreviousMinTravelDistance(int oldNumberOfThreads);
	Index* stateToIndex(const State& s, int currentTeam, int upperBound) const;
};
#endif
