//Copyright 2015 Patrik Dürrenberger
//
//This file is part of TTP.
//
//TTP is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//TTP is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

#include <stdio.h>
#include "DistanceMatrix.h"

DistanceMatrix::DistanceMatrix(){
	distances = NULL;
	labels = NULL;
	numberOfTeams = 0;
	isSymmetric = false;
}

DistanceMatrix::DistanceMatrix(const DistanceMatrix* d){
	numberOfTeams = d->numberOfTeams;
	distances = new int*[numberOfTeams];
	labels = new std::string[numberOfTeams];
	for(int i=0; i < numberOfTeams; ++i){
		labels[i] = d->labels[i];
		distances[i] = new int[numberOfTeams];
		for(int j=0; j < numberOfTeams; ++j){
			distances[i][j] = d->distances[i][j];
		}
	}
	isSymmetric = d->isSymmetric;
}

DistanceMatrix::~DistanceMatrix(){
	for(int i = 0; i < numberOfTeams; i++){
		delete[] distances[i];
	}
	delete[] distances;
	delete[] labels;
}

void DistanceMatrix::setSymmetry(){
	for(int i=0; i<numberOfTeams; ++i){
		for(int j=0; j<i; ++j){
			if(distances[i][j] != distances[j][i]){
				isSymmetric = false;
				return;
			}
		}
	}
	isSymmetric = true;
}
