//Copyright 2015 Patrik Dürrenberger
//
//This file is part of TTP.
//
//TTP is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//TTP is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

#include "Index.h"
#include "../findMinTravelDistance.h"

#ifndef PATTERN_DATABASE_H
#define PATTERN_DATABASE_H

class PatternDatabase{
private:
	int numberOfTeams;
	int currentTeam;
	int upperBound;
	int* database;
	FindMinTravelDistance* minTravelDistanceFinder;

	void setUpDatabase();
	int calculateHeuristic(const Index &idx);

public:
	PatternDatabase(){}
	PatternDatabase(DistanceMatrix* distMatrix, int currentTeam, int lowerBound, int upperBound);
	~PatternDatabase();
	int getEntry(const State &state, int currentTeam, int upperBound) const;
};

#endif
