//Copyright 2015 Patrik Dürrenberger
//
//This file is part of TTP.
//
//TTP is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//TTP is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

#include <cmath>

#include "PatternDatabase.h"

int PatternDatabase::calculateHeuristic(const Index &idx){
	return minTravelDistanceFinder->findTeamsMinTravelDistance(idx, currentTeam);
}

void PatternDatabase::setUpDatabase(){
	Index* i = Index::buildStartIndex(numberOfTeams, currentTeam, upperBound);
	int h = 0;
	while(i->next()){
		if(!(i->getNumberOfConsecutiveAwayGames() != 0 && i->getLastTeamPlayedAway() == -1)){
			h = calculateHeuristic(*i);
		}
		database[i->hashCode()] = h;
	}
	delete i;
}

PatternDatabase::PatternDatabase(DistanceMatrix* distMatrix, int currentTeam, int lowerBound,
		int upperBound){
	numberOfTeams = distMatrix->numberOfTeams;
	this->currentTeam = currentTeam;
	this->upperBound = upperBound;
	minTravelDistanceFinder = new FindMinTravelDistance(distMatrix, lowerBound, upperBound);
	int databaseSize = numberOfTeams * (upperBound+1) * numberOfTeams * numberOfTeams * pow(2,numberOfTeams-1);
	database = new int[databaseSize];
	setUpDatabase();
}

PatternDatabase::~PatternDatabase(){
	delete[] database;
	delete minTravelDistanceFinder;
}

int PatternDatabase::getEntry(const State &state, int currentTeam, int upperBound) const{
	return database[Index::hashCode(state, currentTeam, upperBound)];
}
