//Copyright 2015 Patrik Dürrenberger
//
//This file is part of TTP.
//
//TTP is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//TTP is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

#include "../Subset.h"
#include "../State.h"

#ifndef INDEX_H
#define INDEX_H

class Index{
private:
	int remainingAwayGames;
	int remainingHomeGames;
	//set of teams to play away
	Subset* teamsToPlayAway;
	int numberOfConsecutiveAwayGames;
	//the previous team's number if played away, else -1
	int lastTeamPlayedAway;

	//auxiliary variables
	int numberOfTeams;
	int upperBound;
	int currentTeam;
	int counter;

	bool doStep(int stepNumber);
	int* getVariable(int stepNumber);
	int getBound(int stepNumber);
	int lastTeamPlayedAwayPart() const;
	static int lastTeamPlayedAwayPart(int currentTeam, int lastTeamPlayed, int numberOfConsecutiveAwayGames);
	int teamsToPlayAwayPart() const;
	static int teamsToPlayAwayPart(bool* stillHasToPlayAway, int numberOfTeams, int currentTeam);

public:
	Index(){}
	Index(int rag, int rhg, Subset* ttpa, int nocag, int ltp, int nmbot, int ct, int ub);
	~Index();
	bool operator!=(const Index &idx) const;
	int getRemainingAwayGames() const;
	int getRemainingHomeGames() const;
	bool* getTeamsToPlayAway() const;
	int getNumberOfConsecutiveAwayGames() const;
	int getLastTeamPlayedAway() const;
	static Index* buildStartIndex(int numberOfTeams, int currentTeam, int upperBound);
	bool next();
	int hashCode() const;
	static int hashCode(const State &state, int currentTeam, int upperBound);
	void printIndex() const;
};

#endif
