//Copyright 2015 Patrik Dürrenberger
//
//This file is part of TTP.
//
//TTP is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//TTP is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

#include <iostream>
#include <cmath>

#include "Index.h"

Index::Index(int rag, int rhg, Subset* ttpa, int nocag, int ltpa, int nmbot, int ct, int ub){
	remainingAwayGames = rag;
	remainingHomeGames = rhg;
	teamsToPlayAway = ttpa;
	numberOfConsecutiveAwayGames = nocag;
	lastTeamPlayedAway = ltpa;
	numberOfTeams = nmbot;
	upperBound = ub;
	counter = 0;
	currentTeam = ct;
}

Index::~Index(){
	delete teamsToPlayAway;
}

bool Index::operator!=(const Index &idx) const{
	if(remainingAwayGames != idx.remainingAwayGames) return true;
	if(remainingHomeGames != idx.remainingHomeGames) return true;
	if(numberOfConsecutiveAwayGames != idx.numberOfConsecutiveAwayGames) return true;
	if(lastTeamPlayedAway != idx.lastTeamPlayedAway) return true;
	if(teamsToPlayAway != idx.teamsToPlayAway) return true;
	return false;
}

Index* Index::buildStartIndex(int numberOfTeams, int currentTeam, int upper){
	int zero = 0;
	Subset* startSet = new Subset(numberOfTeams-1, numberOfTeams);
	//do the first step
	startSet->doStep(zero, currentTeam);
	return new Index(0, 0, startSet, 0, -2, numberOfTeams, currentTeam, upper);
}

bool Index::doStep(int stepNumber){
	if(stepNumber == 4){
		//returns false if all subsets have been seen
		return teamsToPlayAway->doStep(++counter, currentTeam);
	}

	//to prevent that lastTeamPlayed is currentTeam after a next()-call to an index
	if(stepNumber == 0 && currentTeam == (lastTeamPlayedAway+1)%numberOfTeams){
		++lastTeamPlayedAway;
	}

	int* variable = getVariable(stepNumber);
	int bound = getBound(stepNumber);
	if(*variable < bound){
		++(*variable);
		return true;
	}else{
		*variable = 0;
		if(stepNumber == 0) *variable = -1;
		return doStep(++stepNumber);
	}
}

int* Index::getVariable(int stepNumber){
	if(stepNumber == 0){
		return &lastTeamPlayedAway;
	}else if(stepNumber == 1){
		return &numberOfConsecutiveAwayGames;
	}else if(stepNumber == 2){
		return &remainingAwayGames;
	}else if(stepNumber == 3){
		return &remainingHomeGames;
	}else{
		std::cout << "ERROR in Index::getVariable()" << std::endl;
	}
	return NULL;
}

int Index::getBound(int stepNumber){
	if(stepNumber == 0 || stepNumber == 2 || stepNumber == 3){
		return numberOfTeams-1;
	}else if(stepNumber == 1){
		return upperBound;
	}else{
		std::cout << "ERROR in Index::getBound()" << std::endl;
	}
	return -1;
}

bool Index::next(){
	return doStep(0);
}

int Index::getNumberOfConsecutiveAwayGames() const{
	return numberOfConsecutiveAwayGames;
}

int Index::getLastTeamPlayedAway() const{
	return lastTeamPlayedAway;
}

bool* Index::getTeamsToPlayAway() const{
	bool* stillHasToPlayAway = new bool[numberOfTeams];
	for(int i=0; i<numberOfTeams; ++i){
		stillHasToPlayAway[i] = teamsToPlayAway->teamInSubset(i);
	}
	return stillHasToPlayAway;
}

int Index::getRemainingAwayGames() const{
	return remainingAwayGames;
}

int Index::getRemainingHomeGames() const{
	return remainingHomeGames;
}

int Index::hashCode() const{
	int hash = lastTeamPlayedAwayPart()
				+ numberOfTeams * numberOfConsecutiveAwayGames
				+ numberOfTeams * (upperBound+1) * remainingAwayGames
				+ numberOfTeams * (upperBound+1) * numberOfTeams * remainingHomeGames
				+ numberOfTeams * (upperBound+1) * numberOfTeams * numberOfTeams * teamsToPlayAwayPart();

	/*std::cout << hash;
	printIndex();
	std::cout << std::endl;*/

	return hash;
}

//static method
int Index::hashCode(const State &state, int currentTeam, int upperBound){
	int hash = lastTeamPlayedAwayPart(currentTeam, state.lastTeamPlayed[currentTeam], state.numberOfConsecutiveAwayGames[currentTeam])
					+ state.numberOfTeams * state.numberOfConsecutiveAwayGames[currentTeam]
					+ state.numberOfTeams * (upperBound+1) * (state.numberOfMatchdays/2-state.timesPlayedAway[currentTeam])
					+ state.numberOfTeams * (upperBound+1) * state.numberOfTeams * (state.numberOfMatchdays/2-state.timesPlayedHome[currentTeam])
					+ state.numberOfTeams * (upperBound+1) * state.numberOfTeams * state.numberOfTeams * teamsToPlayAwayPart(state.stillHasToPlayAway[currentTeam], state.numberOfTeams, currentTeam);
	return hash;
}

//returns a number between 0 and numberOfTeams-1
int Index::lastTeamPlayedAwayPart() const{
	if(currentTeam > lastTeamPlayedAway) return lastTeamPlayedAway+1;
	return lastTeamPlayedAway;
}

//static method
int Index::lastTeamPlayedAwayPart(int currentTeam, int lastTeamPlayed, int numberOfConsecutiveAwayGames){
	if(numberOfConsecutiveAwayGames == 0) return 0;
	if(currentTeam > lastTeamPlayed) return lastTeamPlayed+1;
	return lastTeamPlayed;
}

//returns a value between 0 and 2^(numberOfTeams-1)-1
int Index::teamsToPlayAwayPart() const{
	int bias = 0;
	int hash = 0;
	for(int i=0; i<numberOfTeams; ++i){
		if(i != currentTeam){
			if(currentTeam < i) bias = -1;
			if(teamsToPlayAway->teamInSubset(i)){
				hash += pow(2,i+bias);
			}
		}
	}
	return hash;
}

int Index::teamsToPlayAwayPart(bool* stillHasToPlayAway, int numberOfTeams, int currentTeam){
	int bias = 0;
	int hash = 0;
	for(int i=0; i<numberOfTeams; ++i){
		if(i != currentTeam){
			if(currentTeam < i) bias = -1;
			if(stillHasToPlayAway[i]){
				hash += pow(2,i+bias);
			}
		}
	}
	return hash;
}

void Index::printIndex() const{
	std::cout << "\t[" << lastTeamPlayedAway << ", " << numberOfConsecutiveAwayGames
		 << ", " << remainingAwayGames << ", " << remainingHomeGames << ", ";
	teamsToPlayAway->print();
	std::cout << "]";
}
