import argparse
import os
import subprocess

from Pipeline import Vectorizer, VectorFinder

DEBUG1 = not True
DEBUG2 = not True
DEBUG3 = not True

def print_debug(x):
	if DEBUG:
		print("DEBUG_INFO: "+str(x))
LOS_FILE_NAME = "los_result.txt"
SAS_FILE_NAME = "output.sas"
WEIGHT_FILE_NAME = "weight_file.txt"

MAX_REFINEMENT_ITERATIONS = 10000

def print_debug1(x):
    if DEBUG1:
        print("DEBUG 1: "+str(x))
def print_debug2(x):
    if DEBUG2:
        print("DEBUG 2: "+str(x))
def print_debug3(x):
    if DEBUG3:
        print("DEBUG 3: "+str(x))

def saveFile(lines, path):
	f = open(path, "w+")
	for line in lines:

		f.write(str(line)[2:-1] + "\n")
	f.close

def runFMM(command):
    string = ""
    for word in command:
        string += word+" "
    print_debug3(string)
    p = subprocess.Popen(command, stdout=subprocess.PIPE, shell=False)
    outs, errs = p.communicate()
    if errs is not None:
        errlines = errs.splitlines()
        printAll(errlines)
        print('Error Occurred = true')
        exit(1)
    else:
        return outs.splitlines()

def create_dalm_batch_collection(args):
	fd = os.getenv(args.fast_downward)
	benchmark = os.getenv(args.benchmark)
	command = [fd + '/fast-downward.py', "--keep-sas-file", benchmark + args.problem, "--search", "astar(lmcount(lm_merged([lm_rhw(), lm_hm(m=1)])))"]

	outs = runFMM(command)
	#os.rename("output.sas", fd + "/output.sas")

	saveFile(outs, "output.dalm")
	dalm_file_path = "output.dalm"
	sas_file_path = "output.sas"

	dalm_vector_batch_collection, complain_list = Vectorizer.extract_dalm_vector_batch_collection(
		dalm_file_path,
		sas_file_path)
	return dalm_vector_batch_collection, complain_list

def update_loc_result(args):
	# Build command
	fd = os.getenv(args.fast_downward)
	benchmark = os.getenv(args.benchmark)

	command = [fd + '/fast-downward.py', "--keep-sas-file", benchmark + args.problem, "--search",
			   "los(simons_potentials())"]#weight_file = "+WEIGHT_FILE_NAME+"))"]


	#looking for local optimum
	outs = runFMM(command)
	#os.rename(SAS_FILE_NAME, fd + "/"+SAS_FILE_NAME)

	saveFile(outs, LOS_FILE_NAME)

def loc_exist(los_file_path):
	b = False
	with open(los_file_path, "r") as los_text:
		los_text_list = los_text.read().split("\n")
		for line in los_text_list:
			if "FOUND STATE WITHOUT IMPROVING SUCC" in line:
				b = True
				break
	return b

def create_p_a_batch(sas_file_path, los_file_path):
	path_vector_batch, applicable_vector_batch, complain_list, dimension = Vectorizer.extract_loc_vector_batch(
		los_file_path, sas_file_path)
	if not complain_list == []:
		print("ERROR unsupported task")
		print(complain_list)
	return [path_vector_batch,applicable_vector_batch] , dimension

def mip_solve(p_a_list, dalm_batch_collection, dimension):

	solution_exists, solution_vector, continuous_var_count, binary_var_count = VectorFinder.find_refined_vector2(dalm_batch_collection,
																		p_a_list, dimension)
	return solution_exists, solution_vector, continuous_var_count, binary_var_count

def update_weight_file(solution_vector, weight_file_path):
	text = ""
	for weight_idx in range(len(solution_vector)):
		weight = solution_vector[weight_idx]
		text += str(weight + 1000000) + " "
	text = "  " + text
	print_debug2("new weights: " + text)
	saveFile([text], weight_file_path)

if __name__ == "__main__":

	# Read Arguments
	parser = argparse.ArgumentParser(
		description='Computes the weighted vertex cover.')
	parser.add_argument('problem', metavar='p', type=str,
						nargs='?', const=1, default='/driverlog/p01.pddl',
						help='The problem file.')
	parser.add_argument('dalm', metavar='dalm', type=str,
	                    nargs='?', const=1, default='n',
	                    help='Using Disjunctive Action Landmarks (dalm)? [d]: using Dalm, [n]: Not using dalm')
	parser.add_argument('fast_downward', metavar='fd', type=str,
						nargs='?', const=1, default='DOWNWARD_REPO',
						help='Environment variable for the fast downward repo.')
	parser.add_argument('benchmark', metavar='bm', type=str,
						nargs='?', const=1, default='DOWNWARD_BENCHMARKS',
						help='Environment variable for the benchmark.')
	args = parser.parse_args()

	fd = os.getenv(args.fast_downward)

	los_file_path = LOS_FILE_NAME
	sas_file_path = SAS_FILE_NAME
	weight_file_path = WEIGHT_FILE_NAME

	update_weight_file([0], weight_file_path)

	if args.dalm=="d":
		print('using DALM')
		dalm_batch_collection, complaint_list = create_dalm_batch_collection(args)
	else:
		print('not using DALM')
		dalm_batch_collection, complaint_list = [], []

	if not complaint_list == []:
		print(complaint_list)
		print("ERROR: Task not supportet")
	else:
		p_a_list = []
		loop_count = 0
		while True: 			#while loop_count < MAX_REFINEMENT_ITERATIONS:
			print("iteration: " + str(loop_count))
			loop_count += 1
			update_loc_result(args)
			if loc_exist(los_file_path):

				p_a_batch, dimension = create_p_a_batch(sas_file_path, los_file_path)
				p_a_list.append(p_a_batch)
				print_debug3(p_a_list)
				solution_exists, solution_vector, continuous_var_count, binary_var_count =  mip_solve(p_a_list, dalm_batch_collection, dimension)
				if solution_exists:
					update_weight_file(solution_vector, weight_file_path)
				else:
					print("# BM>1")
					break
			else:
				print_debug1("1 dimensional h does exist to show BM=1")
				print("# BM=1")
				print_debug1(solution_vector)
				break
		print("# total_iterations: "+str(loop_count))
		print("# total_continuous_vars: " + str(continuous_var_count))
		print("# total_binary_vars: " + str(binary_var_count))
