#ifndef SEARCH_ENGINES_LOCAL_OPTIMUM_SEARCH_H
#define SEARCH_ENGINES_LOCAL_OPTIMUM_SEARCH_H

#include "../open_list.h"
#include "../search_engine.h"

#include <memory>
#include <vector>
#include <stack>

class Evaluator;
class PruningMethod;

namespace options {
class OptionParser;
class Options;
}

namespace local_optimum_search {
class LocalOptimumSearch : public SearchEngine {

    std::stack<StateID> open_list;
    std::shared_ptr<Evaluator> heuristic;

    

protected:
    virtual void initialize() override;
    virtual SearchStatus step() override;

public:
    explicit LocalOptimumSearch(const options::Options &opts);
    virtual ~LocalOptimumSearch() = default;

    virtual void print_statistics() const override;

    void dump_search_space() const;
};

}

#endif
