#include "simons_potential_heuristic.h"
#include "../option_parser.h"
#include "../utils/memory.h"
#include "../plugin.h"
#include "potential_function.h"
#include <fstream> 
#include <memory>
#include <unordered_map>
#include <vector>

using namespace std;
namespace potentials {


SimonsPotentialHeuristic::SimonsPotentialHeuristic(const Options& opts)
: PotentialHeuristic(opts, nullptr){
    VariablesProxy vars = task_proxy.get_variables();
    vector<vector<double>> weights;
    weights.resize(vars.size(), vector<double>());
    string file_name = opts.get<string>("weight_file");
    ifstream file;
    file.open(file_name);
    double val;
    for (VariableProxy var:vars){
    	for (int i = 0; i < var.get_domain_size(); i++){
		file >> val;
		weights[var.get_id()].push_back(val);    	
    	}
    }
    function = utils::make_unique_ptr<PotentialFunction>(weights);
}

static shared_ptr<Heuristic> _parse(OptionParser &parser) {
    /*char* downward_repo;
    downward_repo = getenv("DOWNWARD_REPO");
    string downward_repo_string = string(downward_repo);
    string default_weight_file = downward_repo_string.append("/weight_file.txt");*/
    string default_weight_file = "weight_file.txt";
    parser.add_option<string>(
        "weight_file",
        "file that contains the weight for the pot heuristic",
        default_weight_file//        "weight_file.txt"
        );
    
   parser.add_option<shared_ptr<AbstractTask>>(
        "transform",
        "Optional task transformation for the heuristic."
        " Currently, adapt_costs() and no_transform() are available.",
        "no_transform()");
    parser.add_option<bool>("cache_estimates", "cache heuristic estimates", "true");
    
    Options opts = parser.parse();
    if (parser.dry_run()){
        return nullptr;
    }

    return make_shared<SimonsPotentialHeuristic>(opts);
}

static Plugin<Evaluator> _plugin(
    "simons_potentials", _parse);
}
