#ifndef CYCLIC_LANDMARKS_DISJ_ACTION_LANDMARK_GRAPH_H
#define CYCLIC_LANDMARKS_DISJ_ACTION_LANDMARK_GRAPH_H

#include "../landmarks/landmark_graph.h"

#include <map>
#include <set>
#include <vector>

namespace landmarks {

enum class OrderingType {
    strong,
    weak,
};

class DisjActionLandmarkNode {
    std::map<int, OrderingType> dependencies;

    void add_dependency_if_stronger(int id, OrderingType type);

public:
    const std::set<int> actions;

    DisjActionLandmarkNode(std::set<int> actions);
    bool overlaps_with(DisjActionLandmarkNode &other) const;
    bool satisfied_by(int op_id) const;
    void add_dependency(int id, OrderingType type);
    OrderingType get_dependency(int id) const;
    std::map<int, OrderingType> get_dependencies() const;
    bool depends_on(int id) const;
};

class DisjActionLandmarkGraph {
    std::map<std::set<int>, size_t> ids;
    std::vector<DisjActionLandmarkNode> lms;

    void add_nodes(const LandmarkGraph &lm_graph,
                   const State &init_state);
    void add_node(const std::set<int> &actions);
    void add_edges(const LandmarkGraph &lm_graph,
                   const State &init_state);
    void add_edge(LandmarkNode &from,
                  std::pair<LandmarkNode* const, EdgeType> &to);
    void add_edge(int from, int to, OrderingType type);
    void dump_lm(int id,const TaskProxy &task) const;
public:
    explicit DisjActionLandmarkGraph(const LandmarkGraph &lm_graph,
                                     const State &init_state);
    size_t get_number_of_landmarks();
    std::set<int> get_actions(int id);
    std::map<int, OrderingType> get_dependencies(int id);
    OrderingType get_ordering_type(int from, int to);
    void dump(const TaskProxy &task) const;
    void dump_dot() const;
};
}

#endif
