#ifndef PARITY_POTENTIALS_XOR_SOLVER_H
#define PARITY_POTENTIALS_XOR_SOLVER_H

#include "augmented_matrix.h"

#include "../algorithms/dynamic_bitset.h"


namespace parity_potentials {

/* Private inheritance so that the matrix can only be altered from
   within XorSolver upon its construction. */
class XorSolver : private AugmentedMatrix {
    int first_non_zero_row;
    void zero_columns_below(int current_row, int current_column);
    int find_pivot_row(int current_row, int current_column) const;
    void gaussian_elimination();

    bool xor_row(Bitset &row, int starting_column) const;
    Bitset back_substitution() const;

public:
    XorSolver(AugmentedMatrix &&matrix);
    bool is_unsolvable();
    Bitset compute_solution_weights();
    bool verify_solution(const Bitset &solution);
    void print_row(const Bitset &row) const;
};

}
#endif
