#ifndef PARITY_POTENTIALS_MUTEX_FINDER_H
#define PARITY_POTENTIALS_MUTEX_FINDER_H

#include "constraint_constructor.h"

#include "../algorithms/dynamic_bitset.h"

#include <utility>

class TaskProxy;
class FactProxy;
class EffectsProxy;
class OperatorProxy;

using Tuple = std::pair<FactProxy, FactProxy>;

namespace parity_potentials {
class ConstraintConstructor;

class MutexFinder {
    const ConstraintConstructor &cc;
    const TaskProxy &tnf_task_proxy;
    const int num_1d_tuples;
    const int num_tuples;
    dynamic_bitset::DynamicBitset<> table;  
    const std::vector<std::pair<FactProxy, FactProxy>> pair_id_to_facts;

    // Non-const functions.
    bool add_to_table(const Bitset &to_add);
    bool extend_to_pair(
        int eff_fact_id,
        const dynamic_bitset::DynamicBitset<> &pre,
        const OperatorProxy &op);

    // Const functions.
    const FactProxy* contains(
        const std::pair<FactProxy, FactProxy> &p,
        const int fact_id) const;
    template <class FactProxyCollection>
    bool contradicts(
        const FactProxy &fact_to_check,
        const FactProxyCollection &facts) const;
    bool contradicts(
        const FactProxy &fact_to_check,
        const EffectsProxy &effs) const;
    template <class FactProxyCollection>
    dynamic_bitset::DynamicBitset<> get_tuples(
        const FactProxyCollection &facts) const;
    dynamic_bitset::DynamicBitset<> get_tuples(
        const EffectsProxy &effects) const;

public:
    /* Create DynamicBitset with length equal to the number of
       one- and two-dimensional features, which is also the number of tuples.
       The entry for a tuple in this Bitset is 1 when it's reachable
       and 0 when it's unreachable. */
    MutexFinder(
        const ConstraintConstructor &cc,
        const TaskProxy &tnf_task_proxy,
        const int num_1d_tuples,
        const dynamic_bitset::DynamicBitset<> &init_tuples,
        const std::vector<std::pair<FactProxy, FactProxy>> &&pair_id_to_facts);
    bool are_mutex(const FactProxy &fact1, const FactProxy &fact2) const;
};


}
#endif
