#ifndef PARITY_POTENTIALS_CONSTRAINT_CONSTRUCTOR_H
#define PARITY_POTENTIALS_CONSTRAINT_CONSTRUCTOR_H

#include "augmented_matrix.h"
#include "mutex_finder.h"

#include "../algorithms/dynamic_bitset.h"

#include <memory>
#include <vector>
#include <utility>

class AbstractTask;
class FactProxy;
class OperatorProxy;
class State;
class TaskProxy;
class VariableProxy;
class VariablesProxy;
class DynamicBitset;
class AugmentedMatrix;
class MutexFinder;

namespace options {
class Options;
}

namespace parity_potentials {
class ConstraintConstructor {
    std::shared_ptr<AbstractTask> tnf_task;
    int num_con_vars;
    int num_1d_tuples;
    int num_tuples;
    std::vector<std::pair<FactProxy, FactProxy>> pair_id_to_facts;
    std::vector<std::vector<int>> con_var_ids;
    std::vector<std::vector<std::vector<std::vector<int>>>> con_pair_var_ids;
    std::vector<std::vector<int>> con_ctx_var_ids;
    std::unique_ptr<MutexFinder> mutex_finder;

    void initialize(const TaskProxy &tnf_task_proxy);
    int get_con_var_id(const OperatorProxy &op, const VariableProxy &var) const;
    TaskProxy get_tnf_task_proxy() const;

    // TODO: Make all these const.
    void construct_separation_constraints(
        AugmentedMatrix &constraint_matrix);
    void construct_consistency_constraints(
        AugmentedMatrix &constraint_matrix);
    void construct_op_consistency_constraints(
        AugmentedMatrix &constraint_matrix,
        const VariablesProxy &vars,
        const OperatorProxy &op);

    bool are_mutex(const FactProxy &fact, const OperatorProxy &op) const;

    bool forget_op_is_unreachable(
        const TaskProxy &tnf_task_proxy,
        const OperatorProxy &op) const;

public:
    explicit ConstraintConstructor(const options::Options &opts);
    // TODO: This also const.
    AugmentedMatrix construct_constraints();
    int get_con_var_id(const FactProxy &fact_proxy) const;
    int get_con_var_id(const FactProxy &fact1, const FactProxy &fact2) const;
};
}
#endif
