#ifndef PARITY_POTENTIALS_AUGMENTED_MATRIX_H
#define PARITY_POTENTIALS_AUGMENTED_MATRIX_H

#include "../algorithms/dynamic_bitset.h"

#include <iostream>
#include <vector>

using Bitset = dynamic_bitset::DynamicBitset<>;

namespace parity_potentials {
class AugmentedMatrix {
    AugmentedMatrix(AugmentedMatrix &matrix);
protected:
    int num_cols;
    int num_rows;
    std::vector<Bitset> matrix;

public:
    AugmentedMatrix(int num_vars);
    AugmentedMatrix(AugmentedMatrix &&matrix);
    Bitset& add_zero_row();
    int get_num_cols();
    int get_num_rows();
    friend std::ostream& operator<<(
        std::ostream &os, const AugmentedMatrix &am);
};
}
#endif
