#include "augmented_matrix.h"

using namespace std;

namespace parity_potentials {
AugmentedMatrix::AugmentedMatrix(int num_vars)
    : num_cols(num_vars+1),
      num_rows(0){
}

AugmentedMatrix::AugmentedMatrix(AugmentedMatrix &/*other*/) {
}

AugmentedMatrix::AugmentedMatrix(AugmentedMatrix &&other)
    : num_cols(move(other.num_cols)),
      num_rows(move(other.num_rows)),
      matrix(move(other.matrix)) {
}

Bitset& AugmentedMatrix::add_zero_row() {
    ++num_rows;
    matrix.emplace_back(num_cols);
    return matrix.back();
}

int AugmentedMatrix::get_num_cols() {
    return num_cols;
}

int AugmentedMatrix::get_num_rows() {
    return num_rows;
}

ostream& operator<<(ostream &os, const AugmentedMatrix &am) {
    for (Bitset row : am.matrix) {
        os << "    ";
        os << row[row.size()-1] << " | ";
        for (int i = row.size() - 2; i >= 0; --i) {
            os << row[i];
        }
        os << endl;
    }
    return os;
}
}
