#! /usr/bin/env python

from lab.parser import Parser

class TimerParser(Parser):
    def __init__(self):
        Parser.__init__(self)
        self.add_pattern(
            "construction_time",
            r"Construction time: (.+)s\n",
            type=float,
            file="run.log",
        )
        self.add_pattern(
            "solve_time",
            r"Solve time: (.+)s\n",
            type=float,
            file="run.log",
        )

def main():
    parser = TimerParser()
    parser.parse()


main()
