#! /usr/bin/env python

"""Check for false positives on easy solvable tasks from all domains."""

import os
import os.path
import platform

from downward.experiment import FastDownwardExperiment
from downward.reports.absolute import AbsoluteReport
from downward.reports.scatter import ScatterPlotReport
from lab import cached_revision
from lab.environments import BaselSlurmEnvironment, LocalEnvironment


ATTRIBUTES = ["error", "total_time"]

NODE = platform.node()
if NODE.endswith(".scicore.unibas.ch") or NODE.endswith(".cluster.bc2.ch"):
    ENV = BaselSlurmEnvironment(email="my.name@unibas.ch")
else:
    ENV = LocalEnvironment(processes=2)

SUITE = ["agricola-sat18-strips:p01.pddl",
	 "airport:p01-airport1-p1.pddl",
	 "barman-sat11-strips:pfile06-021.pddl",
	 "barman-sat14-strips:p1-11-4-15.pddl",
	 "blocks:probBLOCKS-4-0.pddl",
	 "childsnack-sat14-strips:child-snack_pfile05.pddl",
	 "data-network-sat18-strips:p01.pddl",
	 "depot:p01.pddl",
	 "driverlog:p01.pddl",
	 "elevators-sat08-strips:p01.pddl",
	 "elevators-sat11-strips:p01.pddl",
	 "floortile-sat11-strips:seq-p01-001.pddl",
	 "floortile-sat14-strips:p01-4-3-2.pddl",
	 "freecell:p01.pddl",
	 "ged-sat14-strips:d-3-6.pddl",
	 "grid:prob01.pddl",
	 "gripper:prob01.pddl",
	 "hiking-sat14-strips:ptesting-1-2-7.pddl",
	 "logistics00:probLOGISTICS-4-0.pddl",
	 "logistics98:prob01.pddl",
	 "miconic:s1-0.pddl",
	 "movie:prob01.pddl",
	 "mprime:prob01.pddl",
	 "mystery:prob01.pddl",
	 "nomystery-sat11-strips:p01.pddl",
	 "openstacks-sat08-strips:p01.pddl",
	 "openstacks-sat11-strips:p01.pddl",
	 "openstacks-sat14-strips:p170_2.pddl",
	 "openstacks-strips:p01.pddl",
	 "organic-synthesis-sat18-strips:p01.pddl",
	 "organic-synthesis-split-sat18-strips:p01.pddl",
	 "parcprinter-08-strips:p01.pddl",
	 "parcprinter-sat11-strips:p01.pddl",
	 "parking-sat11-strips:pfile08-031.pddl",
	 "parking-sat14-strips:p_28_2.pddl",
	 "pathways:p01.pddl",
	 "pegsol-08-strips:p01.pddl",
	 "pegsol-sat11-strips:p01.pddl",
	 "pipesworld-notankage:p01-net1-b6-g2.pddl",
	 "pipesworld-tankage:p01-net1-b6-g2-t50.pddl",
	 "psr-small:p01-s2-n1-l2-f50.pddl",
	 "rovers:p01.pddl",
	 "satellite:p01-pfile1.pddl",
	 "scanalyzer-08-strips:p01.pddl",
	 "scanalyzer-sat11-strips:p01.pddl",
	 "snake-sat18-strips:p01.pddl",
	 "sokoban-sat08-strips:p01.pddl",
	 "sokoban-sat11-strips:p01.pddl",
	 "spider-sat18-strips:p01.pddl",
	 "storage:p01.pddl",
	 "termes-sat18-strips:p01.pddl",
	 "tetris-sat14-strips:p020.pddl",
	 "thoughtful-sat14-strips:p11_6_53-typed.pddl",
	 "tidybot-sat11-strips:p01.pddl",
	 "tpp:p01.pddl",
	 "transport-sat08-strips:p01.pddl",
	 "transport-sat11-strips:p01.pddl",
	 "transport-sat14-strips:p01.pddl",
	 "trucks-strips:p01.pddl",
	 "visitall-sat11-strips:problem12.pddl",
	 "visitall-sat14-strips:pfile30.pddl",
	 "woodworking-sat08-strips:p01.pddl",
	 "woodworking-sat11-strips:p01.pddl",
	 "zenotravel:p01.pddl"]

# Use path to your Fast Downward repository.
REPO = os.environ["DOWNWARD_REPO"]
BENCHMARKS_DIR = os.environ["DOWNWARD_BENCHMARKS"]

# If REVISION_CACHE is None, the default ./data/revision-cache is used.
REVISION_CACHE = os.environ.get("DOWNWARD_REVISION_CACHE")
VCS = cached_revision.get_version_control_system(REPO)
#REV = "default" if VCS == cached_revision.MERCURIAL else "main"
REV = "parity-functions"

exp = FastDownwardExperiment(environment=ENV, revision_cache=REVISION_CACHE)

# Add built-in parsers to the experiment.
exp.add_parser(exp.EXITCODE_PARSER)
exp.add_parser(exp.TRANSLATOR_PARSER)
exp.add_parser(exp.SINGLE_SEARCH_PARSER)
exp.add_parser(exp.PLANNER_PARSER)

exp.add_suite(BENCHMARKS_DIR, SUITE)
exp.add_algorithm("parity", REPO, REV, ["--search", "astar(parity())"])

# Add step that writes experiment files to disk.
exp.add_step("build", exp.build)

# Add step that executes all runs.
exp.add_step("start", exp.start_runs)

# Add step that collects properties from run directories and
# writes them to *-eval/properties.
exp.add_fetcher(name="fetch")

# Add report step (AbsoluteReport is the standard report).
exp.add_report(AbsoluteReport(attributes=ATTRIBUTES), outfile="report.html")

# Parse the commandline and show or run experiment steps.
exp.run_steps()
