#! /usr/bin/env python

import os
import os.path
import platform
from pathlib import Path

from downward.experiment import FastDownwardExperiment
from downward.reports.absolute import AbsoluteReport
from downward.reports.scatter import ScatterPlotReport
from lab.reports import *
from lab import cached_revision
from lab.environments import BaselSlurmEnvironment, LocalEnvironment


NODE = platform.node()
if NODE.endswith(".scicore.unibas.ch") or NODE.endswith(".cluster.bc2.ch"):
	ENV = BaselSlurmEnvironment(email="remo.christen@stud.unibas.ch")
else:
	ENV = LocalEnvironment(processes=2)

SUITE = ["pegsol",
	"sliding-tiles"]

# Use path to your Fast Downward repository.
REPO = os.environ["DOWNWARD_REPO"]
BENCHMARKS_DIR = os.environ["ERIKSSON_BENCHMARKS"]

# If REVISION_CACHE is None, the default ./data/revision-cache is used.
REVISION_CACHE = os.environ.get("DOWNWARD_REVISION_CACHE")

exp = FastDownwardExperiment(environment=ENV, revision_cache=REVISION_CACHE)

# Add built-in parsers to the experiment.
exp.add_parser(exp.EXITCODE_PARSER)
exp.add_parser(exp.TRANSLATOR_PARSER)
exp.add_parser(exp.SINGLE_SEARCH_PARSER)
exp.add_parser(exp.PLANNER_PARSER)
DIR = Path(__file__).resolve().parent
exp.add_parser(DIR / "timer-parser.py")
exp.add_parser(DIR / "matrix-parser.py")

exp.add_suite(BENCHMARKS_DIR, SUITE)


COMMAND = ["--search", "astar(parity())"]
exp.add_algorithm("Full Bitset", REPO, "no-mutex", COMMAND)

# Add step that writes experiment files to disk.
exp.add_step("build", exp.build)

# Add step that executes all runs.
exp.add_step("start", exp.start_runs)

# Add step that collects properties from run directories and
# writes them to *-eval/properties.
exp.add_fetcher(name="fetch")

# Add report step (AbsoluteReport is the standard report).
"""
Default values for Attribute:
name = Attribute(
	"name",
	absolute=False,
	min_wins=True,
	function=sum,
	scale=None,
	digits=2
"""
construction_time = Attribute(
	"construction_time",
	function=geometric_mean,
)
solve_time = Attribute(
	"solve_time",
	function=geometric_mean,
)
memory = Attribute(
	"memory",
	function=geometric_mean,
)
num_cols = Attribute(
	"num_cols",
	absolute=True,
)
num_rows = Attribute(
	"num_rows",
	absolute=True,
)
num_ops = Attribute(
	"num_ops",
	absolute=True,
)
ATTRIBUTES = ["error",
	memory,
	construction_time,
	solve_time,
	"total_time",
	num_rows,
	num_cols,
	num_ops]

exp.add_report(AbsoluteReport(attributes=ATTRIBUTES), outfile="report.html")

# Parse the commandline and show or run experiment steps.
exp.run_steps()
