#! /usr/bin/env python

from lab.parser import Parser

class MatrixParser(Parser):
    def __init__(self):
        Parser.__init__(self)
        self.add_pattern(
            "num_rows",
            r"Number of rows: (.+)\n",
            type=int,
            file="run.log",
        )
        self.add_pattern(
            "num_cols",
            r"Number of columns: (.+)\n",
            type=int,
            file="run.log",
        )
        self.add_pattern(
            "num_ops",
            r"Number of operators: (.+)\n",
            type=int,
            file="run.log",
        )

def main():
    parser = MatrixParser()
    parser.parse()


main()
