#! /usr/bin/env python2.7

import re

from lab.parser import Parser

"""
def error(content, props):
    if props['planner_exit_code'] == 0:
        props['error'] = 'plan-found'
    else:
        props['error'] = 'unsolvable-or-error'


def coverage(content, props):
    props['coverage'] = int(props['planner_exit_code'] == 0)


def get_plan(content, props):
    # All patterns are parsed before functions are called.
    if props.get('evaluations') is not None:
        props['plan'] = re.findall(r'^(?:step)?\s*\d+: (.+)$', content, re.M)


def get_times(content, props):
    props['times'] = re.findall(r'(\d+\.\d+) seconds', content)


def trivially_unsolvable(content, props):
    props['trivially_unsolvable'] = int(
        'ff: goal can be simplified to FALSE. No plan will solve it' in content)
"""

def get_original_goal_found(content, props):
    props['original_goal_found'] = int('Original goal found by forward search!' in content)

def get_initial_state_found(content, props):
    props['initial_state_found'] = int('Initial state found by backwards expansion!' in content)

def get_goal_expansion_stopped(content, props):
    props['goal_expansion_stopped'] = int('Stop goal expansion, no legal expansion found.' in content)

def get_syntax_warning(content, props):
    props['syntax_warning'] = int('WARNING:' in content)

#parser.add_pattern('evaluations', r'evaluating (\d+) states')

parser = Parser()
parser.add_pattern('backwards_expansions', r'Backwards expanded (\d+) state\(s\)\.', type=int)
parser.add_pattern('undone', r'Undone (\d+) state\(s\)\.', type=int)
parser.add_pattern('backwards_ops_in_plan', r'Backwards expanded operators in plan: (\d+)', type=int)

parser.add_function(get_original_goal_found)
parser.add_function(get_initial_state_found)
parser.add_function(get_goal_expansion_stopped)
parser.add_function(get_syntax_warning)

"""
parser.add_function(error)
parser.add_function(coverage)
parser.add_function(get_plan)
parser.add_function(get_times)
parser.add_function(trivially_unsolvable)
"""
parser.parse()
