(define (domain p8x8d8n-domain)

(:requirements :strips :typing :conditional-effects :negative-preconditions :disjunctive-preconditions :universal-preconditions)

(:types
    reagent coordinate percentage - object
    xcoord ycoord - coordinate
    x1 x2 x3 x4 x5 x6 x7 x8 - xcoord
    y1 y2 y3 y4 y5 y6 y7 y8 - ycoord
    hcl kcl bovine gelatin primer beosynucleotide amplitag lambdadna - reagent
    p0 p5 p10 p15 p20 p25 p30 p35 p40 p45 p50 p55 p60 p65 p70 p75 p80 p85 p90 p95 p100 - percentage
)

(:predicates
    (reagent-type ?r - reagent ?x - xcoord ?y - ycoord)
    (occupied ?x - xcoord ?y - ycoord)
    (VICINITY ?xo - xcoord ?yo - ycoord ?xt - xcoord ?yt - ycoord)
    (NEIGHBOUR ?xo - xcoord ?yo - ycoord ?xt - xcoord ?yt - ycoord)
    (blocked ?x - xcoord ?y - ycoord)
    (MIX ?r1 ?r2 ?rt - reagent)
    (small ?x - xcoord ?y - ycoord)
    (mix-percentage ?p - percentage ?x - xcoord ?y - ycoord)
    (NEXTPERCENTAGE ?p1 ?p2 - percentage)
    (moved-west ?x - xcoord ?y - ycoord)
    (moved-west-twice ?x - xcoord ?y - ycoord)
    (moved-west-three-times ?x - xcoord ?y - ycoord)
    (moved-west-four-times ?x - xcoord ?y - ycoord)
    (moved-west-five-times ?x - xcoord ?y - ycoord)
    (moved-east ?x - xcoord ?y - ycoord)
    (moved-east-twice ?x - xcoord ?y - ycoord)
    (moved-east-three-times ?x - xcoord ?y - ycoord)
    (moved-east-four-times ?x - xcoord ?y - ycoord)
    (moved-east-five-times ?x - xcoord ?y - ycoord)
    (moved-north ?x - xcoord ?y - ycoord)
    (moved-north-twice ?x - xcoord ?y - ycoord)
    (moved-north-three-times ?x - xcoord ?y - ycoord)
    (moved-north-four-times ?x - xcoord ?y - ycoord)
    (moved-north-five-times ?x - xcoord ?y - ycoord)
    (moved-south ?x - xcoord ?y - ycoord)
    (moved-south-twice ?x - xcoord ?y - ycoord)
    (moved-south-three-times ?x - xcoord ?y - ycoord)
    (moved-south-four-times ?x - xcoord ?y - ycoord)
    (moved-south-five-times ?x - xcoord ?y - ycoord)
    (ISEAST ?x1 ?x2 - xcoord)
    (ISWEST ?x1 ?x2 - xcoord)
    (ISNORTH ?y1 ?y2 - ycoord)
    (ISSOUTH ?y1 ?y2 - ycoord)
)

(:action spawn_HCL
    :parameters ()
    :precondition (and
        (not (occupied x1 y6))
        (not (occupied x1 y7))
        (not (occupied x1 y8))
        (not (occupied x2 y6))
        (not (occupied x2 y7))
        (not (occupied x2 y8))
    )
    :effect (and
        (reagent-type hcl x1 y7)
        (occupied x1 y7)
        (small x1 y7)
    )
)

(:action spawn_KCL
    :parameters ()
    :precondition (and
        (not (occupied x1 y7))
        (not (occupied x2 y7))
        (not (occupied x3 y7))
        (not (occupied x1 y8))
        (not (occupied x2 y8))
        (not (occupied x3 y8))
    )
    :effect (and
        (reagent-type kcl x2 y8)
        (occupied x2 y8)
        (small x2 y8)
    )
)

(:action spawn_Bovine
    :parameters ()
    :precondition (and
        (not (occupied x6 y7))
        (not (occupied x7 y7))
        (not (occupied x8 y7))
        (not (occupied x6 y8))
        (not (occupied x7 y8))
        (not (occupied x8 y8))
    )
    :effect (and
        (reagent-type bovine x7 y8)
        (occupied x7 y8)
        (small x7 y8)
    )
)

(:action spawn_Gelatin
    :parameters ()
    :precondition (and
        (not (occupied x7 y6))
        (not (occupied x7 y7))
        (not (occupied x7 y8))
        (not (occupied x8 y6))
        (not (occupied x8 y7))
        (not (occupied x8 y8))
    )
    :effect (and
        (reagent-type gelatin x8 y7)
        (occupied x8 y7)
        (small x8 y7)
    )
)

(:action spawn_Primer
    :parameters ()
    :precondition (and
        (not (occupied x1 y1))
        (not (occupied x1 y2))
        (not (occupied x1 y3))
        (not (occupied x2 y1))
        (not (occupied x2 y2))
        (not (occupied x2 y3))
    )
    :effect (and
        (reagent-type primer x1 y2)
        (occupied x1 y2)
        (small x1 y2)
    )
)

(:action spawn_Beosynucleotide
    :parameters ()
    :precondition (and
        (not (occupied x1 y1))
        (not (occupied x2 y1))
        (not (occupied x3 y1))
        (not (occupied x1 y2))
        (not (occupied x2 y2))
        (not (occupied x3 y2))
    )
    :effect (and
        (reagent-type beosynucleotide x2 y1)
        (occupied x2 y1)
        (small x2 y1)
    )
)

(:action spawn_AmpliTag
    :parameters ()
    :precondition (and
        (not (occupied x6 y1))
        (not (occupied x7 y1))
        (not (occupied x8 y1))
        (not (occupied x6 y2))
        (not (occupied x7 y2))
        (not (occupied x8 y2))
    )
    :effect (and
        (reagent-type amplitag x7 y1)
        (occupied x7 y1)
        (small x7 y1)
    )
)

(:action spawn_LamdaDNA
    :parameters ()
    :precondition (and
        (not (occupied x7 y1))
        (not (occupied x7 y2))
        (not (occupied x7 y3))
        (not (occupied x8 y1))
        (not (occupied x8 y2))
        (not (occupied x8 y3))
    )
    :effect (and
        (reagent-type lambdadna x8 y2)
        (occupied x8 y2)
        (small x8 y2)
    )
)

(:action dispose
    :parameters (?r - reagent)
    :precondition (and 
        (reagent-type ?r x8 y4)
    )
    :effect (and
        (not (reagent-type ?r x8 y4))
        (not (occupied x8 y4))
    )
)

(:action move_north
    :parameters (?r - reagent ?xo - xcoord ?yo ?yt - ycoord ?p1 ?p2 - percentage)
    :precondition (and
        (reagent-type ?r ?xo ?yo)
        (ISNORTH ?yt ?yo)
        (not (blocked ?xo ?yt))
        (forall (?x - xcoord)
          (forall (?y - ycoord)
            (imply (and
                (not (and (= ?x ?xo) (= ?y ?yo)))
                (VICINITY ?x ?y ?xo ?yt)
            )
                (not (occupied ?x ?y))
            )
          )
        )
    )
    :effect (and
        (not (reagent-type ?r ?xo ?yo))
        (reagent-type ?r ?xo ?yt)
        (not (occupied ?xo ?yo))
        (occupied ?xo ?yt)
        (when (small ?xo ?yo) (small ?xo ?yt))
        (when (and 
            (moved-north-four-times ?xo ?yo)
            (mix-percentage ?p1 ?xo ?yo)
            (NEXTPERCENTAGE ?p1 ?p2)
        ) (and
            (not (moved-north-four-times ?xo ?yo))
            (not (mix-percentage ?p1 ?xo ?yo))
            (moved-north-five-times ?xo ?yt)
            (mix-percentage ?p2 ?xo ?yt)
        )
        )
        (when (and 
            (moved-north-three-times ?xo ?yo)
            (mix-percentage ?p1 ?xo ?yo)
            (NEXTPERCENTAGE ?p1 ?p2)
        ) (and
            (not (moved-north-three-times ?xo ?yo))
            (not (mix-percentage ?p1 ?xo ?yo))
            (moved-north-four-times ?xo ?yt)
            (mix-percentage ?p2 ?xo ?yt)
        )
        )
        (when (and 
            (moved-north-twice ?xo ?yo)
            (mix-percentage ?p1 ?xo ?yo)
            (NEXTPERCENTAGE ?p1 ?p2)
        ) (and
            (not (moved-north-twice ?xo ?yo))
            (not (mix-percentage ?p1 ?xo ?yo))
            (moved-north-three-times ?xo ?yt)
            (mix-percentage ?p2 ?xo ?yt)
        )
        )
        (when (and 
            (moved-north ?xo ?yo)
        ) (and
            (not (moved-north ?xo ?yo))
            (moved-north-twice ?xo ?yt)
        )
        )
        (when (and
            (not (moved-north-five-times ?xo ?yo))
            (not (moved-north-four-times ?xo ?yo))
            (not (moved-north-three-times ?xo ?yo))
            (not (moved-north-twice ?xo ?yo))
            (not (moved-north ?xo ?yo))
        ) (and
            (not (moved-east ?xo ?yt))
            (not (moved-east-twice ?xo ?yt))
            (not (moved-east-three-times ?xo ?yt))
            (not (moved-east-four-times ?xo ?yt))
            (not (moved-east-five-times ?xo ?yt))
            (not (moved-west ?xo ?yt))
            (not (moved-west-twice ?xo ?yt))
            (not (moved-west-three-times ?xo ?yt))
            (not (moved-west-four-times ?xo ?yt))
            (not (moved-west-five-times ?xo ?yt))
            (not (moved-south ?xo ?yt))
            (not (moved-south-twice ?xo ?yt))
            (not (moved-south-three-times ?xo ?yt))
            (not (moved-south-four-times ?xo ?yt))
            (not (moved-south-five-times ?xo ?yt))
            (moved-north ?xo ?yt)
        )
        )
    )
)

(:action move_south
    :parameters (?r - reagent ?xo - xcoord ?yo ?yt - ycoord ?p1 ?p2 - percentage)
    :precondition (and
        (reagent-type ?r ?xo ?yo)
        (ISSOUTH ?yt ?yo)
        (not (blocked ?xo ?yt))
        (forall (?x - xcoord)
          (forall (?y - ycoord)
            (imply (and
                (not (and (= ?x ?xo) (= ?y ?yo)))
                (VICINITY ?x ?y ?xo ?yt)
            )
                (not (occupied ?x ?y))
            )
          )
        )
    )
    :effect (and
        (not (reagent-type ?r ?xo ?yo))
        (reagent-type ?r ?xo ?yt)
        (not (occupied ?xo ?yo))
        (occupied ?xo ?yt)
        (when (small ?xo ?yo) (small ?xo ?yt))
        (when (and 
            (moved-south-four-times ?xo ?yo)
            (mix-percentage ?p1 ?xo ?yo)
            (NEXTPERCENTAGE ?p1 ?p2)
        ) (and
            (not (moved-south-four-times ?xo ?yo))
            (not (mix-percentage ?p1 ?xo ?yo))
            (moved-south-five-times ?xo ?yt)
            (mix-percentage ?p2 ?xo ?yt)
        )
        )
        (when (and 
            (moved-south-three-times ?xo ?yo)
            (mix-percentage ?p1 ?xo ?yo)
            (NEXTPERCENTAGE ?p1 ?p2)
        ) (and
            (not (moved-south-three-times ?xo ?yo))
            (not (mix-percentage ?p1 ?xo ?yo))
            (moved-south-four-times ?xo ?yt)
            (mix-percentage ?p2 ?xo ?yt)
        )
        )
        (when (and 
            (moved-south-twice ?xo ?yo)
            (mix-percentage ?p1 ?xo ?yo)
            (NEXTPERCENTAGE ?p1 ?p2)
        ) (and
            (not (moved-south-twice ?xo ?yo))
            (not (mix-percentage ?p1 ?xo ?yo))
            (moved-south-three-times ?xo ?yt)
            (mix-percentage ?p2 ?xo ?yt)
        )
        )
        (when (and 
            (moved-south ?xo ?yo)
        ) (and
            (not (moved-south ?xo ?yo))
            (moved-south-twice ?xo ?yt)
        )
        )
        (when (and
            (not (moved-south-five-times ?xo ?yo))
            (not (moved-south-four-times ?xo ?yo))
            (not (moved-south-three-times ?xo ?yo))
            (not (moved-south-twice ?xo ?yo))
            (not (moved-south ?xo ?yo))
        ) (and
            (not (moved-east ?xo ?yt))
            (not (moved-east-twice ?xo ?yt))
            (not (moved-east-three-times ?xo ?yt))
            (not (moved-east-four-times ?xo ?yt))
            (not (moved-east-five-times ?xo ?yt))
            (not (moved-west ?xo ?yt))
            (not (moved-west-twice ?xo ?yt))
            (not (moved-west-three-times ?xo ?yt))
            (not (moved-west-four-times ?xo ?yt))
            (not (moved-west-five-times ?xo ?yt))
            (not (moved-north ?xo ?yt))
            (not (moved-north-twice ?xo ?yt))
            (not (moved-north-three-times ?xo ?yt))
            (not (moved-north-four-times ?xo ?yt))
            (not (moved-north-five-times ?xo ?yt))
            (moved-south ?xo ?yt)
        )
        )
    )
)

(:action move_west
    :parameters (?r - reagent ?xo ?xt - xcoord ?yo - ycoord ?p1 ?p2 - percentage)
    :precondition (and
        (reagent-type ?r ?xo ?yo)
        (ISWEST ?xt ?xo)
        (not (blocked ?xt ?yo))
        (forall (?x - xcoord)
          (forall (?y - ycoord)
            (imply (and
                (not (and (= ?x ?xo) (= ?y ?yo)))
                (VICINITY ?x ?y ?xt ?yo)
            )
                (not (occupied ?x ?y))
            )
          )
        )
    )
    :effect (and
        (not (reagent-type ?r ?xo ?yo))
        (reagent-type ?r ?xt ?yo)
        (not (occupied ?xo ?yo))
        (occupied ?xt ?yo)
        (when (small ?xo ?yo) (small ?xt ?yo))
        (when (and
            (moved-west-four-times ?xo ?yo)
            (mix-percentage ?p1 ?xo ?yo)
            (NEXTPERCENTAGE ?p1 ?p2)
        ) (and
            (not (moved-west-four-times ?xo ?yo))
            (not (mix-percentage ?p1 ?xo ?yo))
            (moved-west-five-times ?xt ?yo)
            (mix-percentage ?p2 ?xt ?yo)
        )
        )
        (when (and 
            (moved-west-three-times ?xo ?yo)
            (mix-percentage ?p1 ?xo ?yo)
            (NEXTPERCENTAGE ?p1 ?p2)
        ) (and
            (not (moved-west-three-times ?xo ?yo))
            (not (mix-percentage ?p1 ?xo ?yo))
            (moved-west-four-times ?xt ?yo)
            (mix-percentage ?p2 ?xt ?yo)
        )
        )
        (when (and 
            (moved-west-twice ?xo ?yo)
            (mix-percentage ?p1 ?xo ?yo)
            (NEXTPERCENTAGE ?p1 ?p2)
        ) (and
            (not (moved-west-twice ?xo ?yo))
            (not (mix-percentage ?p1 ?xo ?yo))
            (moved-west-three-times ?xt ?yo)
            (mix-percentage ?p2 ?xt ?yo)
        )
        )
        (when (and 
            (moved-west ?xo ?yo)
        ) (and
            (not (moved-west ?xo ?yo))
            (moved-west-twice ?xt ?yo)
        )
        )
        (when (and
            (not (moved-west-five-times ?xo ?yo))
            (not (moved-west-four-times ?xo ?yo))
            (not (moved-west-three-times ?xo ?yo))
            (not (moved-west-twice ?xo ?yo))
            (not (moved-west ?xo ?yo))
        ) (and
            (not (moved-east ?xt ?yo))
            (not (moved-east-twice ?xt ?yo))
            (not (moved-east-three-times ?xt ?yo))
            (not (moved-east-four-times ?xt ?yo))
            (not (moved-east-five-times ?xt ?yo))
            (not (moved-north ?xt ?yo))
            (not (moved-north-twice ?xt ?yo))
            (not (moved-north-three-times ?xt ?yo))
            (not (moved-north-four-times ?xt ?yo))
            (not (moved-north-five-times ?xt ?yo))
            (not (moved-south ?xt ?yo))
            (not (moved-south-twice ?xt ?yo))
            (not (moved-south-three-times ?xt ?yo))
            (not (moved-south-four-times ?xt ?yo))
            (not (moved-south-five-times ?xt ?yo))
            (moved-west ?xt ?yo)
        )
        )
    )
)

(:action move_east
    :parameters (?r - reagent ?xo ?xt - xcoord ?yo - ycoord ?p1 ?p2 - percentage)
    :precondition (and
        (reagent-type ?r ?xo ?yo)
        (ISEAST ?xt ?xo)
        (not (blocked ?xt ?yo))
        (forall (?x - xcoord)
          (forall (?y - ycoord)
            (imply (and
                (not (and (= ?x ?xo) (= ?y ?yo)))
                (VICINITY ?x ?y ?xt ?yo)
            )
                (not (occupied ?x ?y))
            )
          )
        )
    )
    :effect (and
        (not (reagent-type ?r ?xo ?yo))
        (reagent-type ?r ?xt ?yo)
        (not (occupied ?xo ?yo))
        (occupied ?xt ?yo)
        (when (small ?xo ?yo) (small ?xt ?yo))
        (when (and
            (moved-east-four-times ?xo ?yo)
            (mix-percentage ?p1 ?xo ?yo)
            (NEXTPERCENTAGE ?p1 ?p2)
        ) (and
            (not (moved-east-four-times ?xo ?yo))
            (not (mix-percentage ?p1 ?xo ?yo))
            (moved-east-five-times ?xt ?yo)
            (mix-percentage ?p2 ?xt ?yo)
        )
        )
        (when (and 
            (moved-east-three-times ?xo ?yo)
            (mix-percentage ?p1 ?xo ?yo)
            (NEXTPERCENTAGE ?p1 ?p2)
        ) (and
            (not (moved-east-three-times ?xo ?yo))
            (not (mix-percentage ?p1 ?xo ?yo))
            (moved-east-four-times ?xt ?yo)
            (mix-percentage ?p2 ?xt ?yo)
        )
        )
        (when (and 
            (moved-east-twice ?xo ?yo)
            (mix-percentage ?p1 ?xo ?yo)
            (NEXTPERCENTAGE ?p1 ?p2)
        ) (and
            (not (moved-east-twice ?xo ?yo))
            (not (mix-percentage ?p1 ?xo ?yo))
            (moved-east-three-times ?xt ?yo)
            (mix-percentage ?p2 ?xt ?yo)
        )
        )
        (when (and 
            (moved-east ?xo ?yo)
        ) (and
            (not (moved-east ?xo ?yo))
            (moved-east-twice ?xt ?yo)
        )
        )
        (when (and
            (not (moved-east-five-times ?xo ?yo))
            (not (moved-east-four-times ?xo ?yo))
            (not (moved-east-three-times ?xo ?yo))
            (not (moved-east-twice ?xo ?yo))
            (not (moved-east ?xo ?yo))
        ) (and
            (not (moved-west ?xt ?yo))
            (not (moved-west-twice ?xt ?yo))
            (not (moved-west-three-times ?xt ?yo))
            (not (moved-west-four-times ?xt ?yo))
            (not (moved-west-five-times ?xt ?yo))
            (not (moved-north ?xt ?yo))
            (not (moved-north-twice ?xt ?yo))
            (not (moved-north-three-times ?xt ?yo))
            (not (moved-north-four-times ?xt ?yo))
            (not (moved-north-five-times ?xt ?yo))
            (not (moved-south ?xt ?yo))
            (not (moved-south-twice ?xt ?yo))
            (not (moved-south-three-times ?xt ?yo))
            (not (moved-south-four-times ?xt ?yo))
            (not (moved-south-five-times ?xt ?yo))
            (moved-east ?xt ?yo)
        )
        )
    )
)

(:action merge_x
    :parameters (?r1 ?r2 ?r3 - reagent ?x1 ?x2 ?xt - xcoord ?yt - ycoord)
    :precondition (and
        (reagent-type ?r1 ?x1 ?yt)
        (reagent-type ?r2 ?x2 ?yt)
        (small ?x1 ?yt)
        (small ?x2 ?yt)
        (NEIGHBOUR ?x1 ?yt ?xt ?yt)
        (NEIGHBOUR ?x2 ?yt ?xt ?yt)
        (not (blocked ?xt ?yt))
        (MIX ?r1 ?r2 ?r3)
    )
    :effect (and
        (not (reagent-type ?r1 ?x1 ?yt))
        (not (reagent-type ?r2 ?x2 ?yt))
        (reagent-type ?r3 ?xt ?yt)
        (not (occupied ?x1 ?yt))
        (not (occupied ?x2 ?yt))
        (occupied ?xt ?yt)
        (mix-percentage p0 ?xt ?yt)
    )
)

(:action merge_y
    :parameters (?r1 ?r2 ?r3 - droplet ?xt - xcoord ?y1 ?y2 ?yt - ycoord)
    :precondition (and
        (reagent-type ?r1 ?xt ?y1)
        (reagent-type ?r2 ?xt ?y2)
        (small ?xt ?y1)
        (small ?xt ?y2)
        (NEIGHBOUR ?xt ?y1 ?xt ?yt)
        (NEIGHBOUR ?xt ?y2 ?xt ?yt)
        (not (blocked ?xt ?yt))
        (MIX ?r1 ?r2 ?r3)
    )
    :effect (and
        (not (reagent-type ?r1 ?xt ?y1))
        (not (reagent-type ?r2 ?xt ?y2))
        (reagent-type ?r3 ?xt ?yt)
        (not (occupied ?xt ?y1))
        (not (occupied ?xt ?y2))
        (occupied ?xt ?yt)
        (mix-percentage p0 ?xt ?yt)
    )
)

(:action split_x
    :parameters (?r - reagent ?xo ?xl ?xr - xcoord ?yo - ycoord)
    :precondition (and
        (reagent-type ?r ?xo ?yo)
        (mix-percentage p100 ?xo ?yo)
        (NEIGHBOUR ?xo ?yo ?xl ?yo)
        (NEIGHBOUR ?xo ?yo ?xr ?yo)
        (not (= ?xl ?xr))
        (not (small ?xo ?yo))
        (forall (?x - xcoord)
          (forall (?y - ycoord)
            (imply (and
                (not (and (= ?x ?xo) (= ?y ?yo)))
                (or
                    (VICINITY ?x ?y ?xl ?yo)
                    (VICINITY ?x ?y ?xr ?yo)
                )
            )
                (not (occupied ?x ?y))
            )
          )
        )
    )
    :effect (and
        (not (reagent-type ?r ?xo ?yo))
        (not (occupied ?xo ?yo))
        (small ?xl ?yo)
        (reagent-type ?r ?xl ?yo)
        (occupied ?xl ?yo)
        (small ?xr ?yo)
        (reagent-type ?r ?xr ?yo)
        (occupied ?xr ?yo)
    )
)

(:action split_y
    :parameters (?r - reagent ?xo - xcoord ?yo ?yt ?yb - ycoord)
    :precondition (and
        (reagent-type ?r ?xo ?yo)
        (mix-percentage p100 ?xo ?yo)
        (NEIGHBOUR ?xo ?yo ?xo ?yt)
        (NEIGHBOUR ?xo ?yo ?xo ?yb)
        (not (= ?yt ?yb))
        (not (small ?xo ?yo))
        (forall (?x - xcoord)
          (forall (?y - ycoord)
            (imply (and
                (not (and (= ?x ?xo) (= ?y ?yo)))
                (or
                    (VICINITY ?x ?y ?xo ?yt)
                    (VICINITY ?x ?y ?xo ?yb)
                )
            )
                (not (occupied ?x ?y))
            )
          )
        )
    )
    :effect (and
        (not (reagent-type ?r ?xo ?yo))
        (not (occupied ?xo ?yo))
        (small ?xo ?yt)
        (reagent-type ?r ?xo ?yt)
        (occupied ?xo ?yt)
        (small ?xo ?yb)
        (reagent-type ?r ?xo ?yb)
        (occupied ?xo ?yb)
    )
)


)