(define (domain p8x8merge_mixer_durative-domain)

(:requirements :strips :typing :conditional-effects :negative-preconditions :disjunctive-preconditions :universal-preconditions :action-costs :durative-actions)

(:types
    reagent coordinate - object
    xcoord ycoord - coordinate
    x1 x2 x3 x4 x5 x6 x7 x8 - xcoord
    y1 y2 y3 y4 y5 y6 y7 y8 - ycoord
    hcl kcl bovine gelatin primer beosynucleotide amplitag lambdadna - reagent
)

(:predicates
    (reagent-type ?r - reagent ?x - xcoord ?y - ycoord)
    (occupied ?x - xcoord ?y - ycoord)
    (VICINITY ?xo - xcoord ?yo - ycoord ?xt - xcoord ?yt - ycoord)
    (blocked ?x - xcoord ?y - ycoord)
    (MIX ?r1 ?r2 ?rt - reagent)
    (is-mixed ?x - xcoord ?y - ycoord)
    (small ?x - xcoord ?y - ycoord)
    (ISEAST ?x1 ?x2 - xcoord)
    (ISWEST ?x1 ?x2 - xcoord)
    (ISNORTH ?y1 ?y2 - ycoord)
    (ISSOUTH ?y1 ?y2 - ycoord)
)

(:durative-action spawn_HCL
    :parameters ()
    :duration (= ?duration 1)
    :condition (and
        (over all (not (occupied x1 y6)))
        (over all (not (occupied x1 y7)))
        (over all (not (occupied x1 y8)))
        (over all (not (occupied x2 y6)))
        (over all (not (occupied x2 y7)))
        (over all (not (occupied x2 y8)))
    )
    :effect (and
        (at end (reagent-type hcl x1 y7))
        (at end (occupied x1 y7))
        (at end (small x1 y7))
    )
)

(:durative-action spawn_KCL
    :parameters ()
    :duration (= ?duration 1)
    :condition (and
        (over all (not (occupied x1 y7)))
        (over all (not (occupied x2 y7)))
        (over all (not (occupied x3 y7)))
        (over all (not (occupied x1 y8)))
        (over all (not (occupied x2 y8)))
        (over all (not (occupied x3 y8)))
    )
    :effect (and
        (at end (reagent-type kcl x2 y8))
        (at end (occupied x2 y8))
        (at end (small x2 y8))
    )
)

(:durative-action spawn_Bovine
    :parameters ()
    :duration (= ?duration 1)
    :condition (and
        (over all (not (occupied x6 y7)))
        (over all (not (occupied x7 y7)))
        (over all (not (occupied x8 y7)))
        (over all (not (occupied x6 y8)))
        (over all (not (occupied x7 y8)))
        (over all (not (occupied x8 y8)))
    )
    :effect (and
        (at end (reagent-type bovine x7 y8))
        (at end (occupied x7 y8))
        (at end (small x7 y8))
    )
)

(:durative-action spawn_Gelatin
    :parameters ()
    :duration (= ?duration 1)
    :condition (and
        (over all (not (occupied x7 y6)))
        (over all (not (occupied x7 y7)))
        (over all (not (occupied x7 y8)))
        (over all (not (occupied x8 y6)))
        (over all (not (occupied x8 y7)))
        (over all (not (occupied x8 y8)))
    )
    :effect (and
        (at end (reagent-type gelatin x8 y7))
        (at end (occupied x8 y7))
        (at end (small x8 y7))
    )
)

(:durative-action spawn_Primer
    :parameters ()
    :duration (= ?duration 1)
    :condition (and
        (over all (not (occupied x1 y1)))
        (over all (not (occupied x1 y2)))
        (over all (not (occupied x1 y3)))
        (over all (not (occupied x2 y1)))
        (over all (not (occupied x2 y2)))
        (over all (not (occupied x2 y3)))
    )
    :effect (and
        (at end (reagent-type primer x1 y2))
        (at end (occupied x1 y2))
        (at end (small x1 y2))
    )
)

(:durative-action spawn_Beosynucleotide
    :parameters ()
    :duration (= ?duration 1)
    :condition (and
        (over all (not (occupied x1 y1)))
        (over all (not (occupied x2 y1)))
        (over all (not (occupied x3 y1)))
        (over all (not (occupied x1 y2)))
        (over all (not (occupied x2 y2)))
        (over all (not (occupied x3 y2)))
    )
    :effect (and
        (at end (reagent-type beosynucleotide x2 y1))
        (at end (occupied x2 y1))
        (at end (small x2 y1))
    )
)

(:durative-action spawn_AmpliTag
    :parameters ()
    :duration (= ?duration 1)
    :condition (and
        (over all (not (occupied x6 y1)))
        (over all (not (occupied x7 y1)))
        (over all (not (occupied x8 y1)))
        (over all (not (occupied x6 y2)))
        (over all (not (occupied x7 y2)))
        (over all (not (occupied x8 y2)))
    )
    :effect (and
        (at end (reagent-type amplitag x7 y1))
        (at end (occupied x7 y1))
        (at end (small x7 y1))
    )
)

(:durative-action spawn_LamdaDNA
    :parameters ()
    :duration (= ?duration 1)
    :condition (and
        (over all (not (occupied x7 y1)))
        (over all (not (occupied x7 y2)))
        (over all (not (occupied x7 y3)))
        (over all (not (occupied x8 y1)))
        (over all (not (occupied x8 y2)))
        (over all (not (occupied x8 y3)))
    )
    :effect (and
        (at end (reagent-type lambdadna x8 y2))
        (at end (occupied x8 y2))
        (at end (small x8 y2))
    )
)

(:durative-action dispose
    :parameters (?r - reagent)
    :duration (= ?duration 1)
    :condition (and 
        (over all (reagent-type ?r x8 y4))
    )
    :effect (and
        (at start (not (reagent-type ?r x8 y4)))
        (at start (not (occupied x8 y4)))
        (at start (not (small x8 y4)))
        (at start (not (is-mixed x8 y4)))
    )
)

(:durative-action move_north
    :parameters (?r - reagent ?xo - xcoord ?yo ?yt - ycoord)
    :duration (= ?duration 1)
    :condition (and
        (at start (reagent-type ?r ?xo ?yo))
        (over all (ISNORTH ?yt ?yo))
        (over all (not (blocked ?xo ?yt)))
        (over all (forall (?x - xcoord)
          (forall (?y - ycoord)
            (imply (and
                (not (and (= ?x ?xo) (= ?y ?yo)))
                (VICINITY ?x ?y ?xo ?yt)
            )
                (not (occupied ?x ?y))
            )
          )
        ))
    )
    :effect (and
        (when (at start (small ?xo ?yo)) (at end (small ?xo ?yt)))
        (at end (not (small ?xo ?yo)))
        (when (at start (is-mixed ?xo ?yo)) (at end (is-mixed ?xo ?yt)))
        (at end (not (is-mixed ?xo ?yo)))
        (at start (not (reagent-type ?r ?xo ?yo)))
        (at end (reagent-type ?r ?xo ?yt))
        (at end (not (occupied ?xo ?yo)))
        (at start (occupied ?xo ?yt))
    )
)

(:durative-action move_south
    :parameters (?r - reagent ?xo - xcoord ?yo ?yt - ycoord)
    :duration (= ?duration 1)
    :condition (and
        (at start (reagent-type ?r ?xo ?yo))
        (over all (ISSOUTH ?yt ?yo))
        (over all (not (blocked ?xo ?yt)))
        (over all (forall (?x - xcoord)
          (forall (?y - ycoord)
            (imply (and
                (not (and (= ?x ?xo) (= ?y ?yo)))
                (VICINITY ?x ?y ?xo ?yt)
            )
                (not (occupied ?x ?y))
            )
          )
        ))
    )
    :effect (and
        (when (at start (small ?xo ?yo)) (at end (small ?xo ?yt)))
        (at end (not (small ?xo ?yo)))
        (when (at start (is-mixed ?xo ?yo)) (at end (is-mixed ?xo ?yt)))
        (at end (not (is-mixed ?xo ?yo)))
        (at start (not (reagent-type ?r ?xo ?yo)))
        (at end (reagent-type ?r ?xo ?yt))
        (at end (not (occupied ?xo ?yo)))
        (at start (occupied ?xo ?yt))
    )
)

(:durative-action move_west
    :parameters (?r - reagent ?xo ?xt - xcoord ?yo - ycoord)
    :duration (= ?duration 1)
    :condition (and
        (at start (reagent-type ?r ?xo ?yo))
        (over all (ISWEST ?xt ?xo))
        (over all (not (blocked ?xt ?yo)))
        (over all (forall (?x - xcoord)
          (forall (?y - ycoord)
            (imply (and
                (not (and (= ?x ?xo) (= ?y ?yo)))
                (VICINITY ?x ?y ?xt ?yo)
            )
                (not (occupied ?x ?y))
            )
          )
        ))
    )
    :effect (and
        (when (at start (small ?xo ?yo)) (at end (small ?xt ?yo)))
        (at end (not (small ?xo ?yo)))
        (when (at start (is-mixed ?xo ?yo)) (at end (is-mixed ?xt ?yo)))
        (at end (not (is-mixed ?xo ?yo)))
        (at start (not (reagent-type ?r ?xo ?yo)))
        (at end (reagent-type ?r ?xt ?yo))
        (at end (not (occupied ?xo ?yo)))
        (at start (occupied ?xt ?yo))
    )
)

(:durative-action move_east
    :parameters (?r - reagent ?xo ?xt - xcoord ?yo - ycoord)
    :duration (= ?duration 1)
    :condition (and
        (at start (reagent-type ?r ?xo ?yo))
        (over all (ISEAST ?xt ?xo))
        (over all (not (blocked ?xt ?yo)))
        (over all (forall (?x - xcoord)
          (forall (?y - ycoord)
            (imply (and
                (not (and (= ?x ?xo) (= ?y ?yo)))
                (VICINITY ?x ?y ?xt ?yo)
            )
                (not (occupied ?x ?y))
            )
          )
        ))
    )
    :effect (and
        (when (at start (small ?xo ?yo)) (at end (small ?xt ?yo)))
        (at end (not (small ?xo ?yo)))
        (when (at start (is-mixed ?xo ?yo)) (at end (is-mixed ?xt ?yo)))
        (at end (not (is-mixed ?xo ?yo)))
        (at start (not (reagent-type ?r ?xo ?yo)))
        (at end (reagent-type ?r ?xt ?yo))
        (at end (not (occupied ?xo ?yo)))
        (at start (occupied ?xt ?yo))
    )
)

(:durative-action merge_x
    :parameters (?r1 ?r2 ?r3 - reagent ?x1 ?x2 ?xt - xcoord ?yt - ycoord)
    :duration (= ?duration 1)
    :condition (and
        (at start (reagent-type ?r1 ?x1 ?yt))
        (at start (reagent-type ?r2 ?x2 ?yt))
        (at start (small ?x1 ?yt))
        (at start (small ?x2 ?yt))
        (over all (ISEAST ?x1 ?xt))
        (over all (ISWEST ?x2 ?xt))
        (over all (not (blocked ?xt ?yt)))
        (over all (MIX ?r1 ?r2 ?r3))
    )
    :effect (and
        (at start (not (reagent-type ?r1 ?x1 ?yt)))
        (at start (not (reagent-type ?r2 ?x2 ?yt)))
        (at start (not (small ?xt ?yt)))
        (at start (not (small ?x1 ?yt)))
        (at start (not (small ?x2 ?yt)))
        (at end (not (occupied ?x1 ?yt)))
        (at end (not (occupied ?x2 ?yt)))
        (at end (reagent-type ?r3 ?xt ?yt))
        (at start (occupied ?xt ?yt))
    )
)

(:durative-action merge_y
    :parameters (?r1 ?r2 ?r3 - droplet ?xt - xcoord ?y1 ?y2 ?yt - ycoord)
    :duration (= ?duration 1)
    :condition (and
        (at start (reagent-type ?r1 ?xt ?y1))
        (at start (reagent-type ?r2 ?xt ?y2))
        (at start (small ?xt ?y1))
        (at start (small ?xt ?y2))
        (over all (ISNORTH ?y1 ?yt))
        (over all (ISSOUTH ?y2 ?yt))
        (over all (not (blocked ?xt ?yt)))
        (over all (MIX ?r1 ?r2 ?r3))
    )
    :effect (and
        (at start (not (reagent-type ?r1 ?xt ?y1)))
        (at start (not (reagent-type ?r2 ?xt ?y2)))
        (at start (not (small ?xt ?yt)))
        (at start (not (small ?xt ?y1)))
        (at start (not (small ?xt ?y2)))
        (at end (not (occupied ?xt ?y1)))
        (at end (not (occupied ?xt ?y2)))
        (at end (reagent-type ?r3 ?xt ?yt))
        (at start (occupied ?xt ?yt))
    )
)

(:durative-action split_x
    :parameters (?r - reagent ?xo ?xl ?xr - xcoord ?yo - ycoord)
    :duration (= ?duration 1)
    :condition (and
        (at start (reagent-type ?r ?xo ?yo))
        (at start (is-mixed ?xo ?yo))
        (over all (ISWEST ?xl ?xo))
        (over all (ISEAST ?xr ?xo))
        (over all (not (small ?xo ?yo)))
        (over all (forall (?x - xcoord)
          (forall (?y - ycoord)
            (imply (and
                (not (and (= ?x ?xo) (= ?y ?yo)))
                (or
                    (VICINITY ?x ?y ?xl ?yo)
                    (VICINITY ?x ?y ?xr ?yo)
                )
            )
                (not (occupied ?x ?y))
            )
          )
        ))
    )
    :effect (and
        (at start (not (reagent-type ?r ?xo ?yo)))
        (at end (not (occupied ?xo ?yo)))
        (at start (not (is-mixed ?xo ?yo)))
        (at end (small ?xl ?yo))
        (at end (reagent-type ?r ?xl ?yo))
        (at start (occupied ?xl ?yo))
        (at end (small ?xr ?yo))
        (at end (reagent-type ?r ?xr ?yo))
        (at start (occupied ?xr ?yo))
    )
)

(:durative-action split_y
    :parameters (?r - reagent ?xo - xcoord ?yo ?yt ?yb - ycoord)
    :duration (= ?duration 1)
    :condition (and
        (at start (reagent-type ?r ?xo ?yo))
        (at start (is-mixed ?xo ?yo))
        (over all (ISNORTH ?yt ?yo))
        (over all (ISSOUTH ?yb ?yo))
        (over all (not (small ?xo ?yo)))
        (over all (forall (?x - xcoord)
          (forall (?y - ycoord)
            (imply (and
                (not (and (= ?x ?xo) (= ?y ?yo)))
                (or
                    (VICINITY ?x ?y ?xo ?yt)
                    (VICINITY ?x ?y ?xo ?yb)
                )
            )
                (not (occupied ?x ?y))
            )
          )
        ))
    )
    :effect (and
        (at start (not (reagent-type ?r ?xo ?yo)))
        (at end (not (occupied ?xo ?yo)))
        (at start (not (is-mixed ?xo ?yo)))
        (at end (small ?xo ?yt))
        (at end (reagent-type ?r ?xo ?yt))
        (at start (occupied ?xo ?yt))
        (at end (small ?xo ?yb))
        (at end (reagent-type ?r ?xo ?yb))
        (at start (occupied ?xo ?yb))
    )
)

(:durative-action mix_top_right
    :parameters (?r - reagent ?x - xcoord ?y - ycoord)
    :duration (= ?duration 48)
    :condition (and
        (at start (reagent-type ?r ?x ?y))
        (at start (not (small ?x ?y)))
        (over all (not (occupied x4 y8)))
        (over all (not (occupied x4 y7)))
        (over all (not (occupied x4 y6)))
        (over all (not (occupied x5 y6)))
        (over all (not (occupied x6 y6)))
        (over all (not (occupied x7 y6)))
        (over all (not (occupied x8 y6)))
        (over all (or
            (and
                (= ?x x5)
                (= ?y y8)
                (not (occupied x5 y7))
                (not (occupied x6 y8))
                (not (occupied x6 y7))
                (not (occupied x7 y8))
                (not (occupied x7 y7))
                (not (occupied x8 y8))
                (not (occupied x8 y7))
            )
            (and
                (= ?x x5)
                (= ?y y7)
                (not (occupied x5 y8))
                (not (occupied x6 y8))
                (not (occupied x6 y7))
                (not (occupied x7 y8))
                (not (occupied x7 y7))
                (not (occupied x8 y8))
                (not (occupied x8 y7))
            )
            (and
                (= ?x x8)
                (= ?y y8)
                (not (occupied x5 y8))
                (not (occupied x5 y7))
                (not (occupied x6 y8))
                (not (occupied x6 y7))
                (not (occupied x7 y8))
                (not (occupied x7 y7))
                (not (occupied x8 y7))
            )
            (and
                (= ?x x8)
                (= ?y y7)
                (not (occupied x5 y8))
                (not (occupied x5 y7))
                (not (occupied x6 y8))
                (not (occupied x6 y7))
                (not (occupied x7 y8))
                (not (occupied x7 y7))
                (not (occupied x8 y8))
            )
        ))
    )
    :effect (and
        (at end (is-mixed ?x ?y))
    )
)

(:durative-action mix_bottom_left
    :parameters (?r - reagent ?x - xcoord ?y - ycoord)
    :duration (= ?duration 48)
    :condition (and
        (at start (reagent-type ?r ?x ?y))
        (at start (not (small ?x ?y)))
        (over all (not (occupied x1 y3)))
        (over all (not (occupied x2 y3)))
        (over all (not (occupied x3 y3)))
        (over all (not (occupied x4 y3)))
        (over all (not (occupied x5 y3)))
        (over all (not (occupied x5 y2)))
        (over all (not (occupied x5 y1)))
        (over all (or
            (and
                (= ?x x1)
                (= ?y y1)
                (not (occupied x1 y2))
                (not (occupied x2 y1))
                (not (occupied x2 y2))
                (not (occupied x3 y1))
                (not (occupied x3 y2))
                (not (occupied x4 y1))
                (not (occupied x4 y2))
            )
            (and
                (= ?x x1)
                (= ?y y2)
                (not (occupied x1 y1))
                (not (occupied x2 y1))
                (not (occupied x2 y2))
                (not (occupied x3 y1))
                (not (occupied x3 y2))
                (not (occupied x4 y1))
                (not (occupied x4 y2))
            )
            (and
                (= ?x x4)
                (= ?y y1)
                (not (occupied x1 y1))
                (not (occupied x1 y2))
                (not (occupied x2 y1))
                (not (occupied x2 y2))
                (not (occupied x3 y1))
                (not (occupied x3 y2))
                (not (occupied x4 y2))
            )
            (and
                (= ?x x4)
                (= ?y y2)
                (not (occupied x1 y1))
                (not (occupied x1 y2))
                (not (occupied x2 y1))
                (not (occupied x2 y2))
                (not (occupied x3 y1))
                (not (occupied x3 y2))
                (not (occupied x4 y1))
            )
        ))
    )
    :effect (and
        (at end (is-mixed ?x ?y))
    )
)

)