(define (domain p2merge_no_module-domain)

(:requirements :strips :typing :conditional-effects :negative-preconditions :disjunctive-preconditions :universal-preconditions)

(:types
    reagent coordinate percentage - object
    xcoord ycoord - coordinate
    x1 x2 x3 x4 x5 x6 x7 x8 - xcoord
    y1 y2 y3 y4 y5 y6 y7 y8 - ycoord
    bovine gelatin - reagent
    p0 p5 p10 p15 p20 p25 p30 p35 p40 p45 p50 p55 p60 p65 p70 p75 p80 p85 p90 p95 p100 - percentage
)

(:predicates
    (reagent-type ?r - reagent ?x - xcoord ?y - ycoord)
    (occupied ?x - xcoord ?y - ycoord)
    (VICINITY ?xo - xcoord ?yo - ycoord ?xt - xcoord ?yt - ycoord)
    (blocked ?x - xcoord ?y - ycoord)
    (MIX ?r1 ?r2 ?rt - reagent)
    (small ?x - xcoord ?y - ycoord)
    (mix-percentage ?p - percentage ?x - xcoord ?y - ycoord)
    (NEXTPERCENTAGE ?p1 ?p2 - percentage)
    (moved-west ?x - xcoord ?y - ycoord)
    (moved-east ?x - xcoord ?y - ycoord)
    (moved-north ?x - xcoord ?y - ycoord)
    (moved-south ?x - xcoord ?y - ycoord)
    (moved-once ?x - xcoord ?y - ycoord)
    (moved-twice ?x - xcoord ?y - ycoord)
    (moved-three-times ?x - xcoord ?y - ycoord)
    (moved-four-times ?x - xcoord ?y - ycoord)
    (moved-five-plus-times ?x - xcoord ?y - ycoord)
    (ISEAST ?x1 ?x2 - xcoord)
    (ISWEST ?x1 ?x2 - xcoord)
    (ISNORTH ?y1 ?y2 - ycoord)
    (ISSOUTH ?y1 ?y2 - ycoord)
)

(:action spawn_Bovine
    :parameters ()
    :precondition (and
        (not (occupied x6 y7))
        (not (occupied x7 y7))
        (not (occupied x8 y7))
        (not (occupied x6 y8))
        (not (occupied x7 y8))
        (not (occupied x8 y8))
    )
    :effect (and
        (reagent-type bovine x7 y8)
        (occupied x7 y8)
        (small x7 y8)
        (mix-percentage p100 x7 y8)
    )
)

(:action spawn_Gelatin
    :parameters ()
    :precondition (and
        (not (occupied x7 y6))
        (not (occupied x7 y7))
        (not (occupied x7 y8))
        (not (occupied x8 y6))
        (not (occupied x8 y7))
        (not (occupied x8 y8))
    )
    :effect (and
        (reagent-type gelatin x8 y7)
        (occupied x8 y7)
        (small x8 y7)
        (mix-percentage p100 x8 y7)
    )
)

(:action dispose
    :parameters (?r - reagent)
    :precondition (and 
        (reagent-type ?r x8 y4)
    )
    :effect (and
        (not (reagent-type ?r x8 y4))
        (not (occupied x8 y4))
        (not (small x8 y4))
        (not (moved-west x8 y4))
        (not (moved-east x8 y4))
        (not (moved-north x8 y4))
        (not (moved-south x8 y4))
        (not (moved-once x8 y4))
        (not (moved-twice x8 y4))
        (not (moved-three-times x8 y4))
        (not (moved-four-times x8 y4))
        (not (moved-five-plus-times x8 y4))
        (forall (?p - percentage)
            (not (mix-percentage ?p x8 y4))
        )
    )
)

(:action move_north
    :parameters (?r - reagent ?xo - xcoord ?yo ?yt - ycoord ?p1 - percentage)
    :precondition (and
        (reagent-type ?r ?xo ?yo)
        (ISNORTH ?yt ?yo)
        (mix-percentage ?p1 ?xo ?yo)
        (not (blocked ?xo ?yt))
        (forall (?x - xcoord)
          (forall (?y - ycoord)
            (imply (and
                (not (and (= ?x ?xo) (= ?y ?yo)))
                (VICINITY ?x ?y ?xo ?yt)
            )
                (not (occupied ?x ?y))
            )
          )
        )
    )
    :effect (and
        (when (small ?xo ?yo) (and
            (small ?xo ?yt)
            (not (small ?xo ?yo))
            )
        )
        (forall (?p2 - percentage) (and
            (when (and 
                (moved-north ?xo ?yo)
                (moved-four-times ?xo ?yo)
                (NEXTPERCENTAGE ?p1 ?p2)
            ) (and
                (not (moved-north ?xo ?yo))
                (not (moved-four-times ?xo ?yo))
                (not (mix-percentage ?p1 ?xo ?yo))
                (moved-north ?xo ?yt)
                (moved-five-plus-times ?xo ?yt)
                (mix-percentage ?p2 ?xo ?yt)
            )
            )
            (when (and
                (moved-north ?xo ?yo)
                (moved-three-times ?xo ?yo)
                (NEXTPERCENTAGE ?p1 ?p2)
            ) (and
                (not (moved-north ?xo ?yo))
                (not (moved-three-times ?xo ?yo))
                (not (mix-percentage ?p1 ?xo ?yo))
                (moved-north ?xo ?yt)
                (moved-four-times ?xo ?yt)
                (mix-percentage ?p2 ?xo ?yt)
            )
            )
            (when (and 
                (moved-north ?xo ?yo)
                (moved-twice ?xo ?yo)
                (NEXTPERCENTAGE ?p1 ?p2)
            ) (and
                (not (moved-north ?xo ?yo))
                (not (moved-twice ?xo ?yo))
                (not (mix-percentage ?p1 ?xo ?yo))
                (moved-north ?xo ?yt)
                (moved-three-times ?xo ?yt)
                (mix-percentage ?p2 ?xo ?yt)
            )
            )
        ))
        (when (and 
            (moved-north ?xo ?yo)
            (moved-five-plus-times ?xo ?yo)
        ) (and
            (not (moved-north ?xo ?yo))
            (not (moved-five-plus-times ?xo ?yo))
            (not (mix-percentage ?p1 ?xo ?yo))
            (moved-five-plus-times ?xo ?yt)
            (moved-north ?xo ?yt)
            (mix-percentage ?p1 ?xo ?yt)
        )
        )
        (when (and 
            (moved-north ?xo ?yo)
            (moved-once ?xo ?yo)
        ) (and
            (not (moved-north ?xo ?yo))
            (not (moved-once ?xo ?yo))
            (not (mix-percentage ?p1 ?xo ?yo))
            (moved-north ?xo ?yt)
            (moved-twice ?xo ?yt)
            (mix-percentage ?p1 ?xo ?yt)
        )
        )
        (when (and
            (not (moved-north ?xo ?yo))
        ) (and
            (not (moved-east ?xo ?yo))
            (not (moved-west ?xo ?yo))
            (not (moved-south ?xo ?yo))
            (not (moved-once ?xo ?yo))
            (not (moved-twice ?xo ?yo))
            (not (moved-three-times ?xo ?yo))
            (not (moved-four-times ?xo ?yo))
            (not (moved-five-plus-times ?xo ?yo))
            (not (mix-percentage ?p1 ?xo ?yo))
            (moved-north ?xo ?yt)
            (moved-once ?xo ?yt)
            (mix-percentage ?p1 ?xo ?yt)
        )
        )
        (not (reagent-type ?r ?xo ?yo))
        (reagent-type ?r ?xo ?yt)
        (not (occupied ?xo ?yo))
        (occupied ?xo ?yt)
    )
)

(:action move_south
    :parameters (?r - reagent ?xo - xcoord ?yo ?yt - ycoord ?p1 - percentage)
    :precondition (and
        (reagent-type ?r ?xo ?yo)
        (ISSOUTH ?yt ?yo)
        (mix-percentage ?p1 ?xo ?yo)
        (not (blocked ?xo ?yt))
        (forall (?x - xcoord)
          (forall (?y - ycoord)
            (imply (and
                (not (and (= ?x ?xo) (= ?y ?yo)))
                (VICINITY ?x ?y ?xo ?yt)
            )
                (not (occupied ?x ?y))
            )
          )
        )
    )
    :effect (and
        (when (small ?xo ?yo) (and
            (small ?xo ?yt)
            (not (small ?xo ?yo))
            )
        )
        (forall (?p2 - percentage) (and
            (when (and
                (moved-south ?xo ?yo)
                (moved-four-times ?xo ?yo)
                (NEXTPERCENTAGE ?p1 ?p2)
            ) (and
                (not (moved-south ?xo ?yo))
                (not (moved-four-times ?xo ?yo))
                (not (mix-percentage ?p1 ?xo ?yo))
                (moved-south ?xo ?yt)
                (moved-five-plus-times ?xo ?yt)
                (mix-percentage ?p2 ?xo ?yt)
            )
            )
            (when (and
                (moved-south ?xo ?yo)
                (moved-three-times ?xo ?yo)
                (NEXTPERCENTAGE ?p1 ?p2)
            ) (and
                (not (moved-south ?xo ?yo))
                (not (moved-three-times ?xo ?yo))
                (not (mix-percentage ?p1 ?xo ?yo))
                (moved-south ?xo ?yt)
                (moved-four-times ?xo ?yt)
                (mix-percentage ?p2 ?xo ?yt)
            )
            )
            (when (and
                (moved-south ?xo ?yo)
                (moved-twice ?xo ?yo)
                (NEXTPERCENTAGE ?p1 ?p2)
            ) (and
                (not (moved-south ?xo ?yo))
                (not (moved-twice ?xo ?yo))
                (not (mix-percentage ?p1 ?xo ?yo))
                (moved-south ?xo ?yt)
                (moved-three-times ?xo ?yt)
                (mix-percentage ?p2 ?xo ?yt)
            )
            )
        ))
        (when (and 
            (moved-south ?xo ?yo)
            (moved-five-plus-times ?xo ?yo)
        ) (and
            (not (moved-south ?xo ?yo))
            (not (moved-five-plus-times ?xo ?yo))
            (not (mix-percentage ?p1 ?xo ?yo))
            (moved-five-plus-times ?xo ?yt)
            (moved-south ?xo ?yt)
            (mix-percentage ?p1 ?xo ?yt)
        )
        )
        (when (and 
            (moved-south ?xo ?yo)
            (moved-once ?xo ?yo)
        ) (and
            (not (moved-south ?xo ?yo))
            (not (moved-once ?xo ?yo))
            (not (mix-percentage ?p1 ?xo ?yo))
            (moved-south ?xo ?yt)
            (moved-twice ?xo ?yt)
            (mix-percentage ?p1 ?xo ?yt)
        )
        )
        (when (and
            (not (moved-south ?xo ?yo))
        ) (and
            (not (moved-east ?xo ?yo))
            (not (moved-west ?xo ?yo))
            (not (moved-north ?xo ?yo))
            (not (moved-once ?xo ?yo))
            (not (moved-twice ?xo ?yo))
            (not (moved-three-times ?xo ?yo))
            (not (moved-four-times ?xo ?yo))
            (not (moved-five-plus-times ?xo ?yo))
            (not (mix-percentage ?p1 ?xo ?yo))
            (moved-south ?xo ?yt)
            (moved-once ?xo ?yt)
            (mix-percentage ?p1 ?xo ?yt)
        )
        )
        (not (reagent-type ?r ?xo ?yo))
        (reagent-type ?r ?xo ?yt)
        (not (occupied ?xo ?yo))
        (occupied ?xo ?yt)
    )
)

(:action move_west
    :parameters (?r - reagent ?xo ?xt - xcoord ?yo - ycoord ?p1 - percentage)
    :precondition (and
        (reagent-type ?r ?xo ?yo)
        (ISWEST ?xt ?xo)
        (mix-percentage ?p1 ?xo ?yo)
        (not (blocked ?xt ?yo))
        (forall (?x - xcoord)
          (forall (?y - ycoord)
            (imply (and
                (not (and (= ?x ?xo) (= ?y ?yo)))
                (VICINITY ?x ?y ?xt ?yo)
            )
                (not (occupied ?x ?y))
            )
          )
        )
    )
    :effect (and
        (when (small ?xo ?yo) (and
            (small ?xt ?yo)
            (not (small ?xo ?yo))
            )
        )
        (forall (?p2 - percentage) (and
            (when (and
                (moved-west ?xo ?yo)
                (moved-four-times ?xo ?yo)
                (NEXTPERCENTAGE ?p1 ?p2)
            ) (and
                (not (moved-west ?xo ?yo))
                (not (moved-four-times ?xo ?yo))
                (not (mix-percentage ?p1 ?xo ?yo))
                (moved-west ?xt ?yo)
                (moved-five-plus-times ?xt ?yo)
                (mix-percentage ?p2 ?xt ?yo)
            )
            )
            (when (and
                (moved-west ?xo ?yo)
                (moved-three-times ?xo ?yo)
                (NEXTPERCENTAGE ?p1 ?p2)
            ) (and
                (not (moved-west ?xo ?yo))
                (not (moved-three-times ?xo ?yo))
                (not (mix-percentage ?p1 ?xo ?yo))
                (moved-west ?xt ?yo)
                (moved-four-times ?xt ?yo)
                (mix-percentage ?p2 ?xt ?yo)
            )
            )
            (when (and
                (moved-west ?xo ?yo) 
                (moved-twice ?xo ?yo)
                (NEXTPERCENTAGE ?p1 ?p2)
            ) (and
                (not (moved-west ?xo ?yo))
                (not (moved-twice ?xo ?yo))
                (not (mix-percentage ?p1 ?xo ?yo))
                (moved-west ?xt ?yo)
                (moved-three-times ?xt ?yo)
                (mix-percentage ?p2 ?xt ?yo)
            )
            )
        ))
        (when (and
            (moved-west ?xo ?yo)
            (moved-five-plus-times ?xo ?yo)
        ) (and
            (not (moved-west ?xo ?yo))
            (not (moved-five-plus-times ?xo ?yo))
            (not (mix-percentage ?p1 ?xo ?yo))
            (moved-five-plus-times ?xt ?yo)
            (moved-west ?xt ?yo)
            (mix-percentage ?p1 ?xt ?yo)
        )
        )
        (when (and
            (moved-west ?xo ?yo)
            (moved-once ?xo ?yo)
        ) (and
            (not (moved-west ?xo ?yo))
            (not (moved-once ?xo ?yo))
            (not (mix-percentage ?p1 ?xo ?yo))
            (moved-west ?xt ?yo)
            (moved-twice ?xt ?yo)
            (mix-percentage ?p1 ?xt ?yo)
        )
        )
        (when (and
            (not (moved-west ?xo ?yo))
        ) (and
            (not (moved-east ?xo ?yo))
            (not (moved-north ?xo ?yo))
            (not (moved-south ?xo ?yo))
            (not (moved-once ?xo ?yo))
            (not (moved-twice ?xo ?yo))
            (not (moved-three-times ?xo ?yo))
            (not (moved-four-times ?xo ?yo))
            (not (moved-five-plus-times ?xo ?yo))
            (not (mix-percentage ?p1 ?xo ?yo))
            (moved-west ?xt ?yo)
            (moved-once ?xt ?yo)
            (mix-percentage ?p1 ?xt ?yo)
        )
        )
        (not (reagent-type ?r ?xo ?yo))
        (reagent-type ?r ?xt ?yo)
        (not (occupied ?xo ?yo))
        (occupied ?xt ?yo)
    )
)

(:action move_east
    :parameters (?r - reagent ?xo ?xt - xcoord ?yo - ycoord ?p1 - percentage)
    :precondition (and
        (reagent-type ?r ?xo ?yo)
        (ISEAST ?xt ?xo)
        (mix-percentage ?p1 ?xo ?yo)
        (not (blocked ?xt ?yo))
        (forall (?x - xcoord)
          (forall (?y - ycoord)
            (imply (and
                (not (and (= ?x ?xo) (= ?y ?yo)))
                (VICINITY ?x ?y ?xt ?yo)
            )
                (not (occupied ?x ?y))
            )
          )
        )
    )
    :effect (and
        (when (small ?xo ?yo) (and
            (small ?xt ?yo)
            (not (small ?xo ?yo))
            )
        )
        (forall (?p2 - percentage) (and
            (when (and
                (moved-east ?xo ?yo)
                (moved-four-times ?xo ?yo)
                (NEXTPERCENTAGE ?p1 ?p2)
            ) (and
                (not (moved-east ?xo ?yo))
                (not (moved-four-times ?xo ?yo))
                (not (mix-percentage ?p1 ?xo ?yo))
                (moved-east ?xt ?yo)
                (moved-five-plus-times ?xt ?yo)
                (mix-percentage ?p2 ?xt ?yo)
            )
            )
            (when (and
                (moved-east ?xo ?yo)
                (moved-three-times ?xo ?yo)
                (NEXTPERCENTAGE ?p1 ?p2)
            ) (and
                (not (moved-east ?xo ?yo))
                (not (moved-three-times ?xo ?yo))
                (not (mix-percentage ?p1 ?xo ?yo))
                (moved-east ?xt ?yo)
                (moved-four-times ?xt ?yo)
                (mix-percentage ?p2 ?xt ?yo)
            )
            )
            (when (and
                (moved-east ?xo ?yo) 
                (moved-twice ?xo ?yo)
                (NEXTPERCENTAGE ?p1 ?p2)
            ) (and
                (not (moved-east ?xo ?yo))
                (not (moved-twice ?xo ?yo))
                (not (mix-percentage ?p1 ?xo ?yo))
                (moved-east ?xt ?yo)
                (moved-three-times ?xt ?yo)
                (mix-percentage ?p2 ?xt ?yo)
            )
            )
        ))
        (when (and
            (moved-east ?xo ?yo)
            (moved-five-plus-times ?xo ?yo)
        ) (and
            (not (moved-east ?xo ?yo))
            (not (moved-five-plus-times ?xo ?yo))
            (not (mix-percentage ?p1 ?xo ?yo))
            (moved-five-plus-times ?xt ?yo)
            (moved-east ?xt ?yo)
            (mix-percentage ?p1 ?xt ?yo)
        )
        )
        (when (and
            (moved-east ?xo ?yo)
            (moved-once ?xo ?yo)
        ) (and
            (not (moved-east ?xo ?yo))
            (not (moved-once ?xo ?yo))
            (not (mix-percentage ?p1 ?xo ?yo))
            (moved-east ?xt ?yo)
            (moved-twice ?xt ?yo)
            (mix-percentage ?p1 ?xt ?yo)
        )
        )
        (when (and
            (not (moved-east ?xo ?yo))
        ) (and
            (not (moved-west ?xo ?yo))
            (not (moved-north ?xo ?yo))
            (not (moved-south ?xo ?yo))
            (not (moved-once ?xo ?yo))
            (not (moved-twice ?xo ?yo))
            (not (moved-three-times ?xo ?yo))
            (not (moved-four-times ?xo ?yo))
            (not (moved-five-plus-times ?xo ?yo))
            (not (mix-percentage ?p1 ?xo ?yo))
            (moved-east ?xt ?yo)
            (moved-once ?xt ?yo)
            (mix-percentage ?p1 ?xt ?yo)
        )
        )
        (not (reagent-type ?r ?xo ?yo))
        (reagent-type ?r ?xt ?yo)
        (not (occupied ?xo ?yo))
        (occupied ?xt ?yo)
    )
)

(:action merge_x
    :parameters (?r1 ?r2 ?r3 - reagent ?x1 ?x2 ?xt - xcoord ?yt - ycoord)
    :precondition (and
        (reagent-type ?r1 ?x1 ?yt)
        (reagent-type ?r2 ?x2 ?yt)
        (small ?x1 ?yt)
        (small ?x2 ?yt)
        (ISEAST ?x1 ?xt)
        (ISWEST ?x2 ?xt)
        (not (blocked ?xt ?yt))
        (MIX ?r1 ?r2 ?r3)
    )
    :effect (and
        (not (reagent-type ?r1 ?x1 ?yt))
        (not (reagent-type ?r2 ?x2 ?yt))
        (not (small ?xt ?yt))
        (not (small ?x1 ?yt))
        (not (small ?x2 ?yt))
        (not (moved-east ?x1 ?yt))
        (not (moved-west ?x1 ?yt))
        (not (moved-north ?x1 ?yt))
        (not (moved-south ?x1 ?yt))
        (not (moved-once ?x1 ?yt))
        (not (moved-twice ?x1 ?yt))
        (not (moved-three-times ?x1 ?yt))
        (not (moved-four-times ?x1 ?yt))
        (not (moved-five-plus-times ?x1 ?yt))
        (not (moved-east ?x2 ?yt))
        (not (moved-west ?x2 ?yt))
        (not (moved-north ?x2 ?yt))
        (not (moved-south ?x2 ?yt))
        (not (moved-once ?x2 ?yt))
        (not (moved-twice ?x2 ?yt))
        (not (moved-three-times ?x2 ?yt))
        (not (moved-four-times ?x2 ?yt))
        (not (moved-five-plus-times ?x2 ?yt))
        (forall (?p - percentage) (and
            (not (mix-percentage ?p ?x1 ?yt))
            (not (mix-percentage ?p ?x2 ?yt))
        )
        )
        (not (occupied ?x1 ?yt))
        (not (occupied ?x2 ?yt))
        (reagent-type ?r3 ?xt ?yt)
        (occupied ?xt ?yt)
        (mix-percentage p0 ?xt ?yt)
    )
)

(:action merge_y
    :parameters (?r1 ?r2 ?r3 - droplet ?xt - xcoord ?y1 ?y2 ?yt - ycoord)
    :precondition (and
        (reagent-type ?r1 ?xt ?y1)
        (reagent-type ?r2 ?xt ?y2)
        (small ?xt ?y1)
        (small ?xt ?y2)
        (ISNORTH ?y1 ?yt)
        (ISSOUTH ?y2 ?yt)
        (not (blocked ?xt ?yt))
        (MIX ?r1 ?r2 ?r3)
    )
    :effect (and
        (not (reagent-type ?r1 ?xt ?y1))
        (not (reagent-type ?r2 ?xt ?y2))
        (not (small ?xt ?yt))
        (not (small ?xt ?y1))
        (not (small ?xt ?y2))
        (not (occupied ?xt ?y1))
        (not (occupied ?xt ?y2))
        (not (moved-east ?xt ?y1))
        (not (moved-west ?xt ?y1))
        (not (moved-north ?xt ?y1))
        (not (moved-south ?xt ?y1))
        (not (moved-once ?xt ?y1))
        (not (moved-twice ?xt ?y1))
        (not (moved-three-times ?xt ?y1))
        (not (moved-four-times ?xt ?y1))
        (not (moved-five-plus-times ?xt ?y1))
        (not (moved-east ?xt ?y2))
        (not (moved-west ?xt ?y2))
        (not (moved-north ?xt ?y2))
        (not (moved-south ?xt ?y2))
        (not (moved-once ?xt ?y2))
        (not (moved-twice ?xt ?y2))
        (not (moved-three-times ?xt ?y2))
        (not (moved-four-times ?xt ?y2))
        (not (moved-five-plus-times ?xt ?y2))
        (forall (?p - percentage) (and
            (not (mix-percentage ?p ?xt ?y1))
            (not (mix-percentage ?p ?xt ?y2))
        )
        )
        (reagent-type ?r3 ?xt ?yt)
        (occupied ?xt ?yt)
        (mix-percentage p0 ?xt ?yt)
    )
)

(:action split_x
    :parameters (?r - reagent ?xo ?xl ?xr - xcoord ?yo - ycoord)
    :precondition (and
        (reagent-type ?r ?xo ?yo)
        (mix-percentage p100 ?xo ?yo)
        (ISWEST ?xl ?xo)
        (ISEAST ?xr ?xo)
        (not (small ?xo ?yo))
        (forall (?x - xcoord)
          (forall (?y - ycoord)
            (imply (and
                (not (and (= ?x ?xo) (= ?y ?yo)))
                (or
                    (VICINITY ?x ?y ?xl ?yo)
                    (VICINITY ?x ?y ?xr ?yo)
                )
            )
                (not (occupied ?x ?y))
            )
          )
        )
    )
    :effect (and
        (not (reagent-type ?r ?xo ?yo))
        (not (occupied ?xo ?yo))
        (not (moved-east ?xo ?yo))
        (not (moved-west ?xo ?yo))
        (not (moved-north ?xo ?yo))
        (not (moved-south ?xo ?yo))
        (not (moved-once ?xo ?yo))
        (not (moved-twice ?xo ?yo))
        (not (moved-three-times ?xo ?yo))
        (not (moved-four-times ?xo ?yo))
        (not (moved-five-plus-times ?xo ?yo))
        (not (mix-percentage p100 ?xo ?yo))
        (small ?xl ?yo)
        (reagent-type ?r ?xl ?yo)
        (occupied ?xl ?yo)
        (small ?xr ?yo)
        (reagent-type ?r ?xr ?yo)
        (occupied ?xr ?yo)
    )
)

(:action split_y
    :parameters (?r - reagent ?xo - xcoord ?yo ?yt ?yb - ycoord)
    :precondition (and
        (reagent-type ?r ?xo ?yo)
        (mix-percentage p100 ?xo ?yo)
        (ISNORTH ?yt ?yo)
        (ISSOUTH ?yb ?yo)
        (not (small ?xo ?yo))
        (forall (?x - xcoord)
          (forall (?y - ycoord)
            (imply (and
                (not (and (= ?x ?xo) (= ?y ?yo)))
                (or
                    (VICINITY ?x ?y ?xo ?yt)
                    (VICINITY ?x ?y ?xo ?yb)
                )
            )
                (not (occupied ?x ?y))
            )
          )
        )
    )
    :effect (and
        (not (reagent-type ?r ?xo ?yo))
        (not (occupied ?xo ?yo))
        (not (moved-east ?xo ?yo))
        (not (moved-west ?xo ?yo))
        (not (moved-north ?xo ?yo))
        (not (moved-south ?xo ?yo))
        (not (moved-once ?xo ?yo))
        (not (moved-twice ?xo ?yo))
        (not (moved-three-times ?xo ?yo))
        (not (moved-four-times ?xo ?yo))
        (not (moved-five-plus-times ?xo ?yo))
        (not (mix-percentage p100 ?xo ?yo))
        (small ?xo ?yt)
        (reagent-type ?r ?xo ?yt)
        (occupied ?xo ?yt)
        (small ?xo ?yb)
        (reagent-type ?r ?xo ?yb)
        (occupied ?xo ?yb)
    )
)


)