#include "bidirectional_search.h"

#include "../option_parser.h"
#include "../plugin.h"

namespace plugin_bi_bs {
static shared_ptr<SearchEngine> _parse(OptionParser &parser) {
    parser.document_synopsis("Bidirectional brute force search", "");

    parser.add_option<shared_ptr<Evaluator>>("eval", "evaluator for h-value");
    parser.add_option<shared_ptr<Evaluator>>("b_eval", "evaluator for backward h-value");
    parser.add_option<bool>("mutex_pruning","whether we prune mutexes","false");

    SearchEngine::add_pruning_option(parser);
    SearchEngine::add_options_to_parser(parser);
    Options opts = parser.parse();

    shared_ptr<bidirectional_search::BidirectionalSearch> engine;
    if (!parser.dry_run()) {
        opts.set("reopen_closed", true);
        engine = make_shared<bidirectional_search::BidirectionalSearch>(opts);
    }
    return engine;
}

static Plugin<SearchEngine> _plugin("bibs", _parse);
}
