//
// Created by marvin on 14.08.18.
//

#ifndef FAST_DOWNWARD_NBS_SEARCH_H
#define FAST_DOWNWARD_NBS_SEARCH_H

#include "../search_engine.h"
#include "nbs_sub_search.h"

namespace nbs_search {
    const int INFTY = numeric_limits<int>::max();

    class NBSSearch : public SearchEngine {
        const std::shared_ptr<backward_tasks::BackwardTask> backward_task;
        std::shared_ptr<nbs_search::DirectionalSearch> engine_forward;
        std::shared_ptr<nbs_search::DirectionalSearch> engine_backward;
        const bool reopen_closed_nodes;
        int clb = 0;

        options::Options get_ops(bool forward_flag, const options::Options &opts) const;
        SearchStatus check_solved_condition();
        SearchStatus check_failed_condition();
        SearchStatus prepare_best();

    protected:
        void initialize() override;
        SearchStatus step() override;

    public:
        explicit NBSSearch(const options::Options &opts);
        virtual ~NBSSearch() = default;

        virtual void print_statistics() const override;
    };
}

#endif //FAST_DOWNWARD_NBS_SEARCH_H
