//
// Created by marvin on 27.11.18.
//

#ifndef FAST_DOWNWARD_WEIGHTED_DOUBLE_EVALUATOR_H
#define FAST_DOWNWARD_WEIGHTED_DOUBLE_EVALUATOR_H


#include "../evaluator.h"

#include <memory>

namespace options {
    class Options;
}

namespace weighted_double_evaluator {
    class WeightedDoubleEvaluator : public Evaluator {
        std::shared_ptr<Evaluator> evaluator;
        double w;

    public:
        explicit WeightedDoubleEvaluator(const options::Options &opts);
        WeightedDoubleEvaluator(const std::shared_ptr<Evaluator> &eval, double weight);
        virtual ~WeightedDoubleEvaluator() override;

        virtual bool dead_ends_are_reliable() const override;
        virtual EvaluationResult compute_result(
                EvaluationContext &eval_context) override;
        virtual void get_path_dependent_evaluators(std::set<Evaluator *> &evals) override;
    };
}


#endif //FAST_DOWNWARD_WEIGHTED_DOUBLE_EVALUATOR_H
