//
// Created by marvin on 20.11.18.
//

#include "fmm.h"

#include "../option_parser.h"
#include "../plugin.h"

namespace plugin_fmm {
    static shared_ptr<SearchEngine> _parse(OptionParser &parser) {
        parser.document_synopsis("Fractional Meet-in-the-middle.", "");

        parser.add_option<shared_ptr<Evaluator>>("eval", "evaluator for h-value");
        parser.add_option<shared_ptr<Evaluator>>("b_eval", "evaluator for backward h-value");
        parser.add_option<bool>("mutex_pruning", "whether we prune mutexes","false");
        parser.add_option<double>("p", "fraction parameter", "0");
        parser.add_option<bool>("print_g_groups","whether we want to build GMX.","false");

        SearchEngine::add_pruning_option(parser);
        SearchEngine::add_options_to_parser(parser);
        Options opts = parser.parse();

        shared_ptr<fmm::FmmSearch> engine;
        if (!parser.dry_run()) {
            opts.set("reopen_closed", true);
            engine = make_shared<fmm::FmmSearch>(opts);
        }
        return engine;
    }

    static Plugin<SearchEngine> _plugin("fmm", _parse);
}
