//
// Created by marvin on 20.11.18.
//

#ifndef FAST_DOWNWARD_FMM_H
#define FAST_DOWNWARD_FMM_H

#include "../search_engine.h"
#include "fmm_sub.h"

namespace fmm {
    const int INFTY = numeric_limits<int>::max();

    class FmmSearch : public SearchEngine{
        const double p;
        const double p_inverted;
        const std::shared_ptr<backward_tasks::BackwardTask> backward_task;
        std::shared_ptr<fmm::FmmSubSearch> engine_forward;
        std::shared_ptr<fmm::FmmSubSearch> engine_backward;
        const bool reopen_closed_nodes;


        options::Options get_ops(bool forward_flag, const options::Options &opts) const;
        double compute_fraction_p(bool forward_flag, double fraction_p) const;

    protected:
        void initialize() override;
        SearchStatus step() override;

    public:
        explicit FmmSearch(const options::Options &opts);
        virtual ~FmmSearch() = default;

        virtual void print_statistics() const override;
    };

}


#endif //FAST_DOWNWARD_FMM_H
