#ifndef OPERATOR_COUNTING_PHO_CONSTRAINTS_H
#define OPERATOR_COUNTING_PHO_CONSTRAINTS_H

#include "constraint_generator.h"

#include "../pdbs/types.h"

#include <memory>

namespace options {
class Options;
}

namespace landmarks {
class LandmarkFactory;
class LandmarkGraph;
}

namespace operator_counting {
class LMConstraints : public ConstraintGenerator {
    std::shared_ptr<landmarks::LandmarkFactory> lm;
    std::shared_ptr<landmarks::LandmarkGraph> lm_graph;
    bool first = true;
public:
    explicit LMConstraints(const options::Options &opts);

    virtual void initialize_constraints(
        const std::shared_ptr<AbstractTask> &task,
        std::vector<lp::LPConstraint> &constraints,
        double infinity) override;
    virtual bool update_constraints(
        const State &state, lp::LPSolver &lp_solver) override;
};
}

#endif
