#include "lm_constraints.h"

#include "../option_parser.h"
#include "../plugin.h"

#include "../lp/lp_solver.h"

#include "../landmarks/landmark_factory.h"

#include <memory>
#include <vector>

using namespace std;
using namespace landmarks;

namespace operator_counting {
LMConstraints::LMConstraints(const Options &opts)
    : lm(opts.get<shared_ptr<LandmarkFactory>>("lm")) {
}

void LMConstraints::initialize_constraints(
        const shared_ptr<AbstractTask> &task,
        vector<lp::LPConstraint> &constraints,
        double infinity) {
    lm_graph = lm->compute_lm_graph(task);
    constraints.emplace_back(0.0, infinity);
}

    bool LMConstraints::update_constraints(const State &state,
                                       lp::LPSolver &lp_solver) {
    vector<lp::LPConstraint> constraints;

    if (first) first = false;
    else lm_graph = lm->recompute_lm_graph(state);

    for (auto &node : lm_graph->get_nodes()) {
        if (node->is_true_in_state(state)) continue;

        constraints.emplace_back(1.0, lp_solver.get_infinity());
        lp::LPConstraint &constraint = constraints.back();
        /* This probably only works because all nodes in the LM graph that
           we get are fact (or disjunctive fact) landmarks. */
        for (int op_id : node->possible_achievers) {
            constraint.insert(op_id, 1.0);
        }
    }
    lp_solver.add_temporary_constraints(constraints);
    return false;
}

static shared_ptr<ConstraintGenerator> _parse(OptionParser &parser) {
    parser.add_option<shared_ptr<LandmarkFactory>>(
        "lm",
        "landmarks generator",
        "lm_rhw(reasonable_orders=true, conjunctive_landmarks=false)");

    Options opts = parser.parse();
    if (parser.dry_run()) return nullptr;
    return make_shared<LMConstraints>(opts);
}

static Plugin<ConstraintGenerator> _plugin("lm_constraints", _parse);
}
