#ifndef FAST_DOWNWARD_CYCLE_CONSTRAINTS_H
#define FAST_DOWNWARD_CYCLE_CONSTRAINTS_H

#include "constraint_generator.h"
#include "../lp/lp_solver.h"
#include "../task_proxy.h"
#include "../per_state_bitset.h"

#include <map>

namespace options {
class Options;
}

namespace landmarks {
class LandmarkFactory;
class LandmarkGraph;
enum class EdgeType;
}

namespace operator_counting {
class CycleConstraints : public ConstraintGenerator {
    std::shared_ptr<landmarks::LandmarkFactory> lm;
    bool use_cycle_constraints;
    bool first = true;
    double max_cycles = -1;
    bool recomp;
    bool consider_orderings;
    std::map<std::pair<int, int>, int> ordering_types;
    std::shared_ptr<landmarks::LandmarkGraph> lm_graph;
    std::vector<std::pair<int, int>> lm_orderings;
    std::vector<lp::LPConstraint> lm_constraints;
    std::vector<lp::LPConstraint> cycle_constraints;
    std::shared_ptr<PerStateBitset> reached_lms;
    std::shared_ptr<PerStateBitset> reached_orderings;
    std::vector<std::vector<int>> orderings_by_cycle;

    void reject_lms_required_again(const GlobalState &state);
    virtual void compute_constraints(const State &state, double infinity);
    virtual void compute_cycle_constraints(double infinity);
    void compute_orderings();
public:
    explicit CycleConstraints(const options::Options &opts);
    virtual void initialize_constraints(
        const std::shared_ptr<AbstractTask> &task,
        std::vector<lp::LPConstraint> &constraints,
        double infinity) override;
    virtual bool update_constraints(const State &state,
                                    lp::LPSolver &lp_solver) override;
    virtual bool update_constraints(const GlobalState &state,
                                    lp::LPSolver &lp_solver);
    void notify_initial_state(const GlobalState &initial_state);
    bool notify_state_transition(const GlobalState &parent_state,
                                 OperatorID op_id,
                                 const GlobalState &state);
};
}

#endif
