#include <iostream>
#include "johnson_cycle_detection.h"

using namespace std;
using namespace johnson_cycles;

/*
   Run instructions:
   - cd src/search/algorithms
   - g++ johnson_test.cc johnson_cycle_detection.cc sccs.cc
   - ./a.out
 */
int main() {
    vector<vector<int>> graph;
    vector<vector<int>> local;

//    graph.resize(4);
//    graph[0] = {1};
//    graph[1] = {0,2};
//    graph[2] = {1,3};
//    graph[3] = {1};

//    graph.resize(12);
//    graph[0] = {};
//    graph[1] = {};
//    graph[2] = {0};
//    graph[3] = {10,0};
//    graph[4] = {1};
//    graph[5] = {7,1};
//    graph[6] = {2};
//    graph[7] = {0,2};
//    graph[8] = {2,1,7};
//    graph[9] = {4};
//    graph[10] = {1,4};
//    graph[11] = {4,0,10};

    // from grid
    graph.resize(20);
    graph[7] = {};
    graph[6] = {};
    graph[5] = {};
    graph[4] = {};
    graph[19] = {7,6,3,17,0,1,2};
    graph[18] = {3,4};
    graph[17] = {3,10,4,11,5,15,18};
    graph[3] = {6,17,14,5,13,18,9};
    graph[2] = {6,17,14,5,13,18,9};
    graph[16] = {7,6,3,17,0,1,2};
    graph[15] = {2,4};
    graph[14] = {2,10,4,11,5,15,18};
    graph[13] = {10,4,11,5,1,15,18};
    graph[1] = {6,17,14,5,13,18,9};
    graph[12] = {7,6,3,17,0,1,2};
    graph[11] = {1,4};
    graph[10] = {0,4};
    graph[9] = {0,10,4,11,5,15,18};
    graph[0] = {6,17,14,5,13,18,9};
    graph[8] = {7,6,3,17,0,1,2};

    // local
    local.resize(20);
    local[7] = {};
    local[6] = {};
    local[5] = {};
    local[4] = {};
    local[19] = {3,7,6,2,1,0,17};
    local[18] = {3,4};
    local[17] = {3,5,4,18,10,15,11};
    local[3] = {6,5,9,13,18,14,17};
    local[2] = {6,5,9,13,18,14,17};
    local[16] = {3,7,6,2,1,0,17};
    local[15] = {2,4};
    local[14] = {2,5,4,18,10,15,11};
    local[13] = {1,5,4,18,10,15,11};
    local[1] = {6,5,9,13,18,14,17};
    local[12] = {3,7,6,2,1,0,17};
    local[11] = {1,4};
    local[10] = {0,4};
    local[9] = {0,5,4,18,10,15,11};
    local[0] = {6,5,9,13,18,14,17};
    local[8] = {3,7,6,2,1,0,17};

    vector<vector<int>> cycles = compute_elementary_cycles(graph);
    vector<vector<int>> local_cycles = compute_elementary_cycles(local);

    cout << cycles.size() << " cycles:" << endl;
    for (const auto &cycle : cycles) {
        for (const int &c : cycle) cout << c << "-->";
        cout << cycle[0] << endl;
    }
    cout << "=====================================" << endl;
    cout << local_cycles.size() << " local cycles:" << endl;
    for (const auto &cycle : local_cycles) {
        for (const int &c : cycle) cout << c << "-->";
        cout << cycle[0] << endl;
    }
}
