#ifndef FAST_DOWNWARD_CYCLE_HEURISTIC_H
#define FAST_DOWNWARD_CYCLE_HEURISTIC_H

#include "../heuristic.h"
#include "../lp/lp_solver.h"
#include "../operator_counting/cycle_constraints.h"

namespace options {
    class Options;
}

namespace landmarks {
    class LandmarkFactory;
}

namespace cycle_covering_heuristic {
class CycleCoveringHeuristic : public Heuristic {
    bool cycle_constraints;
    bool ip;
    bool recomp;
    bool first = true;
    std::shared_ptr<landmarks::LandmarkFactory> lm;
    lp::LPSolver lp_solver;
    std::shared_ptr<operator_counting::CycleConstraints> constraints_generator;

    virtual int compute_heuristic(const GlobalState &global_state) override;
public:
    explicit CycleCoveringHeuristic(const options::Options &opts);
    virtual ~CycleCoveringHeuristic() override;
    virtual void get_path_dependent_evaluators(std::set<Evaluator *> &evals) {
        evals.insert(this);
    }
    virtual void notify_initial_state(const GlobalState &initial_state){
        if (!recomp) constraints_generator->notify_initial_state(initial_state);
    }
    virtual void notify_state_transition(const GlobalState &parent_state,
            OperatorID op_id, const GlobalState &state) {
        if (!recomp) {
            constraints_generator->notify_state_transition(parent_state, op_id,
                                                       state);
        }
    }

};
}

#endif
