#include "johnson_cycle_detection.h"

#include <algorithm>
#include <cassert>
#include <list>
#include <iostream>

using namespace std;

namespace johnson_cycles {

vector<vector<int>> cycles;
vector<vector<int>> B;
vector<bool> blocked;
vector<int> stack;

bool contains(vector<int> l, int i) {
    return find(l.begin(), l.end(), i) != l.end();
}

void unblock(int u) {

    blocked[u] = false;
    while (!B[u].empty()) {
        int w = B[u].back();
        B[u].pop_back();
        if (blocked[w]) unblock(w);
    }
}

bool circuit(int v, int s, vector<vector<int>> A) {

    bool f = false;
    stack.push_back(v);
    blocked[v] = true;

    for (int w : A[v]) {
        if (w == s) {
            vector<int> cycle;
            cycle.reserve(stack.size());
            for (int n : stack) cycle.push_back(n);
            if (cycle.size() > 1)
                cycles.push_back(cycle);
            f = true;
        } else if (!blocked[w] && w > s) {
            if (circuit(w, s, A)) f = true;
        }
    }

    if (f) unblock(v);
    else {
        for (int w : A[v]) {
            if (find(B[w].begin(), B[w].end(), v) == B[w].end())
                B[w].push_back(v);
        }
    }

    stack.pop_back();
    return f;
}

vector<vector<int>> compute_elementary_cycles(
    vector<vector<int>> &graph) {

    cycles.clear();
    for (auto &list : graph)
        sort(list.begin(), list.end());
    int n = graph.size();
    B.resize(n);
    blocked.resize(n);

    int s = 0;
    while (s < n) {
        for (int i = s; i < n; ++i) {
            blocked[i] = false;
            B[i].clear();
        }
        circuit(s, s, graph);
        s++;
    }
    return cycles;
}
}
