#ifndef FAST_DOWNWARD_IMPLICIT_FORK_CONSTRAINTS_H
#define FAST_DOWNWARD_IMPLICIT_FORK_CONSTRAINTS_H

#include <cmath>
#include  "constraint_generator.h"
#include "../lp/lp_solver.h"
#include "../task_proxy.h"
#include "../implicit_abstractions/fork_abstraction.h"
#include "../implicit_abstractions/cost_partitioning.h"
#include "../utils/logging.h"
//#include <memory>

using namespace std;
using namespace implicit;

class AbstractTask;
class State;

namespace lp {
class LinearProgram;
class LPSolver;
//class LPConstraint;
//struct LPVariable;
}

/*struct VectorHash {
    template <typename T>
    size_t operator()(const vector<T> &vec) const {
        size_t seed = vec.size();
        for (const T &value : vec) {
            seed ^= hash<T>()(value) + 0x9e3779b9 + (seed << 6) + (seed >> 2);
        }
        return seed;
    }
};*/

namespace plugins {
class Options;
}

namespace implicit {
    using LPConstraints = named_vector::NamedVector<lp::LPConstraint>;
    using LPVariables = named_vector::NamedVector<lp::LPVariable>;

class ImplicitForkConstraints : public operator_counting::ConstraintGenerator {
    mutable utils::LogProxy log;
    bool allow_negative_paths;
    double infinity;
    vector<ForwardFork> forward_forks;
    vector<ForkAbstraction> fork_abstractions;
    //{fork_abstraction.root_id, succ.var_id, dom_i, dom_j, root_value, op.original_op_id}
    //{fork_abstraction.root_id, succ.var_id, dom_i, dom_j, root_value}
    unordered_map<vector<int>, int, VectorHash> fork_var_indices;
    //{fork_abstraction.root_id, succ.var_id, dom_i, root_seq, dom_j}
    //{fork_abstraction.root_id, succ.var_id, dom_i, root_seq}
    unordered_map<vector<int>, int, VectorHash> root_seq_var_indices;
    //{fork_abstraction.root_id, root_seq, 2, op_0, op_1}
    //{fork_abstraction.root_id, root_seq, 0, op_0}
    //{fork_abstraction.root_id, root_seq, 1, op_1}
    //{fork_abstraction.root_id, root_seq}
    unordered_map<vector<int>, int, VectorHash> h_var_indices;
    //<fork_abstraction.root_id, largest_domain_size>
    unordered_map<int, int> largest_domain_sizes;

    void create_fixed_root_fork_variables(const ForkAbstraction &fork_abstraction, const TaskProxy &task_proxy,
                                          LPVariables &variables);
    void create_root_seq_fork_variables(const ForkAbstraction &fork_abstraction, const TaskProxy &task_proxy,
                                        LPVariables &variables);
    void create_h_variables(const ForkAbstraction &fork_abstraction, LPVariables &variables);
    void create_operator_cost_constraints(vector<lp::LPConstraint> &temp_constraints,
                                          unordered_map<vector<int>, int, VectorHash> &temp_constraint_indices);
    void create_fixed_root_fork_constraints(const State &state, const ForkAbstraction &fork_abstraction,
                                            vector<lp::LPConstraint> &temp_constraints,
                                            unordered_map<vector<int>, int, VectorHash> &temp_constraint_indices);
    void create_temporary_fork_constraints(const State &state, const ForkAbstraction &fork_abstraction,
                                           vector<lp::LPConstraint> &temp_constraints,
                                           unordered_map<vector<int>, int, VectorHash> &temp_constraint_indices);
    void create_h_constraints(vector<int> &root_sequence, const ForkAbstraction &fork_abstraction,
                              vector<lp::LPConstraint> &temp_constraints,
                              unordered_map<vector<int>, int, VectorHash> &temp_constraint_indices);
    void static add_goal_var_constraints(int root_seq_size, int h_var_index,const ForkAbstraction &fork_abstraction,
                                  vector<lp::LPConstraint> &temp_constraints,
                                  unordered_map<vector<int>, int, VectorHash> &temp_constraint_indices);
    static bool succ_is_goal_var(const ForkAbstraction &fork_abstraction, const ForkSuccessor &succ);
    void static dump_variables(LPVariables &variables);
    void static dump_temp_constraints(vector<lp::LPConstraint> &temp_constraints);

public:
    explicit ImplicitForkConstraints(const lp::LPSolver &lp_solver, const plugins::Options &opts);
    explicit ImplicitForkConstraints(const plugins::Options &opts); // = default;
    /*
      Called upon initialization for the given task. Use this to add permanent
      constraints and perform other initialization.
    */
    virtual void initialize_constraints(
            const shared_ptr<AbstractTask> &task, lp::LinearProgram &lp) override;

    /*
      Called before evaluating a state. Use this to add temporary constraints
      and to set bounds on permanent constraints for this state. All temporary
      constraints are removed automatically after the evalution.

      Returns true if a dead end was detected and false otherwise.
    */
    virtual bool update_constraints(
            const State &state, lp::LPSolver &lp_solver) override;
};
}

#endif
