#include "fork_abstraction.h"
#include "../utils/memory.h"

using namespace std;

namespace implicit {
ForkAbstraction::ForkAbstraction(ForwardFork &forward_fork, const TaskProxy &task_proxy){
    root_id = forward_fork.get_root_id();
    variables = forward_fork.get_variables();
    successors = forward_fork.get_successors();
    root_dom_mapping = {0,1};
    create_root_dom_map(task_proxy.get_variables()[root_id].get_domain_size());
    //initial and goal states now both as vector<FactProxy> instead of having vector<int> initial_state_values
    initial_state.reserve(variables.size());
    abstract_goal.reserve(variables.size());
    State old_initial_state = task_proxy.get_initial_state();
    GoalsProxy goals = task_proxy.get_goals();
    FactProxy root = old_initial_state[root_id];
    initial_state.emplace_back(root_id, root_dom_mapping[root.get_value()],
                               root.get_name(), root.get_variable());
    for (FactProxy goal : goals) {
        if (goal.get_variable().get_id() == root_id) {
            abstract_goal.emplace_back(root_id, root_dom_mapping[goal.get_value()],
                                       goal.get_name(), goal.get_variable());
            break;
        }
    }
    for (ForkSuccessor successor : successors) {
        FactProxy succ = old_initial_state[successor.var_id];
        initial_state.emplace_back(succ.get_variable().get_id(), succ.get_value(),
                                   succ.get_name(), succ.get_variable());
        for (FactProxy goal : goals) {
            if (goal.get_variable().get_id() == successor.var_id) {
                abstract_goal.emplace_back(goal.get_variable().get_id(), goal.get_value(),
                                           goal.get_name(), goal.get_variable());
                break;
            }
        }
    }
    for (const OperatorProxy &op : task_proxy.get_operators()) {
        if (op.is_axiom()) { //check should no longer be needed as all ops in forward fork are non axioms
            continue;
        }
        create_unary_operators(op);
        //Try to use the initial implementation for forward_fork (where we go through effects of operators)
        //to create unary operators... -> later need to fix domain mapping of root and initial
        //operators.emplace_back(op.get_id(), unary_effect, preconditions); create unary effect operators
    }
    //dump(task_proxy);
}

void ForkAbstraction::create_root_dom_map(int domain_size) {
    //TODO add option to have evenly distributed zeroes and ones randomized instead
    srand(44);//all fork abstraction roots will have the same root_dom_mapping
    //Seed 44 is easier for testing than seed 42 (as more difference will how in task)
    for (int i = 2; i < domain_size; i++) {
        root_dom_mapping.push_back(rand() % 2);
    }
    //We can force initial value of 0 later (for each state in LP)
    //Probably no need to force the difference between initial value and goal
    /*root_dom_mapping[initial_state.front().get_value()] = 0;
    if(abstract_goal.front().get_variable().get_id() == root_id) {
        if (initial_state.front().get_value() != abstract_goal.front().get_value()) {
            root_dom_mapping[abstract_goal.front().get_value()] = 1;
        }
    }
    */
    /*bool root_has_different_init_and_goal_value = false;
    if (abstract_goal.front().get_variable().get_id() == root_id) {
        if(initial_state.front().get_value() != abstract_goal.front().get_value()) {
            root_has_different_init_and_goal_value = true;
        }*/

}

void ForkAbstraction::create_unary_operators(const OperatorProxy &op) {
    //vector<ForkSuccessor> successors = forward_fork.get_successors();
    //int root_id = forward_fork.get_root_id();
    bool op_has_effect_on_root = false;
    bool op_has_precondition_on_root = false;
    //vector<OperatorProxy> operators_of_fork = forward_fork.get_operators();
    //Now using AbstractFacts
    //unique_ptr<AbstractFact> root_precondition;
    //unique_ptr<AbstractFact> root_effect;
    //TODO find better solution for this
    vector<AbstractFact> root_precondition;
    vector<AbstractFact> root_effect;
    //unique_ptr<FactProxy> root_precondition;
    //unique_ptr<EffectProxy> root_effect;
    for (const auto &pre: op.get_preconditions()) {
        if (pre.get_variable().get_id() == root_id) {
            //AbstractFact root_precondition(root_id, root_dom_mapping[pre.get_value()],
                                           //pre.get_name(), pre.get_variable() );
            //root_precondition = utils::make_unique_ptr<FactProxy>(pre);
            root_precondition.emplace_back(root_id, root_dom_mapping[pre.get_value()],
                                           pre.get_name(), pre.get_variable());
            /*root_precondition->var_id = root_id;
            root_precondition->value = root_dom_mapping[pre.get_value()];
            root_precondition->name = pre.get_name();
            root_precondition->original_var = pre.get_variable();*/
            op_has_precondition_on_root = true;
            break;
        }
    }
    for (const auto &eff : op.get_effects()) {
        int eff_var_id = eff.get_fact().get_variable().get_id();
        if (eff_var_id == root_id) {
            vector<AbstractFact> preconditions;
            preconditions.reserve(1);
            op_has_effect_on_root = true;
            //root_effect = utils::make_unique_ptr<FactProxy>(eff.get_fact());
            root_effect.emplace_back(root_id, root_dom_mapping[eff.get_fact().get_value()],
                                           eff.get_fact().get_name(), eff.get_fact().get_variable());
            /*root_effect->var_id = root_id;
            root_effect->value = root_dom_mapping[eff.get_fact().get_value()];
            root_effect->name = eff.get_fact().get_name();
            root_effect->original_var = eff.get_fact().get_variable();*/
            if (op_has_precondition_on_root){
                preconditions.push_back(root_precondition.front());
            }
            operators.emplace_back(op.get_id(), eff_var_id, root_effect.front(), preconditions);
            break;
        }
    }
    for (const auto &eff : op.get_effects()) {
        int eff_var_id = eff.get_fact().get_variable().get_id();
        vector<AbstractFact> preconditions;
        preconditions.reserve(2);
        for (ForkSuccessor successor: successors) {
            if (eff_var_id == successor.var_id) {
                if (op_has_effect_on_root) {
                    preconditions.push_back(root_effect.front());
                } else if (op_has_precondition_on_root){
                    preconditions.push_back(root_precondition.front());
                }
                for (const auto &pre: op.get_preconditions()) {
                    if (pre.get_variable().get_id() == successor.var_id) {
                        preconditions.emplace_back(pre.get_variable().get_id(), pre.get_value(),
                                                   pre.get_name(), pre.get_variable());
                        break;
                    }
                }
                AbstractFact effect(eff.get_fact().get_variable().get_id(), eff.get_fact().get_value(),
                                    eff.get_fact().get_name(), eff.get_fact().get_variable());
                /*effect->var_id = eff.get_fact().get_variable().get_id();
                effect->value = eff.get_fact().get_value();
                effect->name = eff.get_fact().get_name();
                effect->original_var = eff.get_fact().get_variable();*/
                operators.emplace_back(op.get_id(), eff_var_id, effect, preconditions);
                break;
            }
        }
    }
}

/* for (const auto &eff : op.get_effects()) {
        int eff_var_id = eff.get_fact().get_variable().get_id();
        vector<FactProxy> preconditions;
        preconditions.reserve(2);
        if (eff_var_id == root_id) {
            EffectProxy root_effect = eff;
            for (const auto &pre: op.get_preconditions()) {
                if (pre.get_variable().get_id() == root_id) {
                    preconditions.push_back(pre);
                }
            }
            operators.emplace_back(op.get_id(), eff_var_id, eff, preconditions);
            create_unary_operator_successor();
            break;
        }
    }
    for (const auto &eff : op.get_effects()) {
        int eff_var_id = eff.get_fact().get_variable().get_id();
        vector<FactProxy> preconditions;
        preconditions.reserve(2);
        for (int successor : successors) {
            if (eff_var_id == successor) {
                if (op_has_effect_on_root) {
                    preconditions.push_back(root_effect);
                } else {
                    preconditions.push_back(root_precondition)
                }
                for (const auto &pre : op.get_preconditions()) {
                    if (pre.get_variable().get_id() == successor) {
                        preconditions.push_back(pre);
                    }
                }
                operators.emplace_back(op.get_id(), eff_var_id, eff, preconditions);
            }
        }
    }*/

void ForkAbstraction::dump(const TaskProxy &task_proxy) {
    //int root_id = forward_fork.get_root_id();
    cout << "Initial State: " << endl;
    for (AbstractFact init : initial_state) {
        cout << init.var_id << " -> " << init.value << ", ";
    }
    cout << endl << "Root ID: " << root_id << " dom: " << task_proxy.get_variables()[root_id].get_domain_size()
    << " -> 2" <<  " Root domain mapping: ";
    for (int value : root_dom_mapping) {
        cout << value << ", ";
    }
    cout << endl;
    cout << "Successors: " << endl;
    for (ForkSuccessor successor : successors) {
        cout << "var_id: " << successor.var_id << ", dom: " << task_proxy.get_variables()[successor.var_id].get_domain_size()
             << endl;
    }
    cout << "Unary Operators: " << endl;
    for (UnaryOperator op : operators) {
        cout << "op: " << op.original_op_id << ", " << op.effect_id << endl << "pre: ";
        for (AbstractFact precondition : op.preconditions) {
            cout  << precondition.var_id << " -> " << precondition.value << " , ";
        }
        cout << endl << "eff: " << op.unary_effect.var_id << " -> " <<
        op.unary_effect.value << endl;
    }
    cout << "Goal: " << endl;
    for (AbstractFact goal : abstract_goal) {
        cout << goal.var_id << " -> " << goal.value << ", ";
    }
    cout << endl;
}
}
