#include "cost_partitioning.h"
//#include "../utils/logging.h"


using namespace std;
using namespace lp;

namespace implicit {
    //TODO potentially allow option for uniform cp
    //TODO add option to restrict to non negative variables
    CostPartitioning::CostPartitioning(const LPSolver &lp_solver){
        infinity = lp_solver.get_infinity();
        /*LPVariables &variables = lp.get_variables();
        LPConstraints &constraints = lp.get_constraints();*/
    }

    void CostPartitioning::initialize_constraints(
            const shared_ptr<AbstractTask> &task, LinearProgram &lp) {
        TaskProxy task_proxy(*task);
        const causal_graph::CausalGraph &cg = causal_graph::get_causal_graph(
                task.get());
        /*utils::g_log << "Causal graph: " << endl;
        for (VariableProxy var : task_proxy.get_variables()) {
            int var_id = var.get_id();
            utils::g_log << "#" << var_id << " [" << var.get_name() << "]:" << endl
                         << "    pre->eff arcs: " << cg.get_pre_to_eff(var_id) << endl
                         << "    eff->pre arcs: " << cg.get_eff_to_pre(var_id) << endl
                         << "    eff->eff arcs: " << cg.get_eff_to_eff(var_id) << endl
                         << "    successors: " << cg.get_successors(var_id) << endl
                         << "    predecessors: " << cg.get_predecessors(var_id) << endl;
        }*/
        LPVariables &variables = lp.get_variables();
        LPConstraints &constraints = lp.get_constraints();
        for (const VariableProxy &var : task_proxy.get_variables()) {
            forward_forks.emplace_back(cg, task_proxy, var.get_id());
        }
        for (ForwardFork &forward_fork : forward_forks) {
            fork_abstractions.emplace_back(forward_fork, task_proxy);
            //cout << forward_fork.get_root_id() << ", ";
        }
        //LPVariables &variables = lp.get_variables();
        //LPConstraints &constraints = lp.get_constraints();
        for (OperatorProxy op : task_proxy.get_operators()){
            create_additivity_constraints(op, constraints, variables);
        }

        for (ForkAbstraction const &fork_abstraction : fork_abstractions){
            create_fixed_root_fork_constraints(fork_abstraction, task_proxy, constraints, variables);
            create_root_seq_fork_variables(fork_abstraction, task_proxy, variables);
            fork_var_indices[{fork_abstraction.root_id}] = variables.size();
            variables.emplace_back(-infinity, infinity, 1, false);
            /*cout << "H-Variable " << fork_var_indices[{fork_abstraction.root_id}] << " added: " << fork_abstraction.root_id;
            cout << ", " << variables.back().lower_bound << " <= " << variables.back().upper_bound << endl;*/
        }
        //dump_variables(variables);
        /* for (IForkAbstraction const &inverted_fork_abstraction : inverted_fork_abstractions){
            create_inverted_fork_constraints(fork_abstraction);
        }*/
        //create_auxiliary_variables(task_proxy, lp.get_variables());
        //create_constraints(task_proxy, lp);
        /*cout << endl;
        cout << variables.size() << " LPVariables:" << endl;
        for (LPVariable lpvar : variables){
            cout << lpvar.lower_bound << "<=" << lpvar.upper_bound << ", obj_coeff:" << lpvar.objective_coefficient << endl;
        }
        cout << endl;*/
    }

    //TODO Note that the order in which unary op vars are created is dependant on original operators and not fork abstractions
    void CostPartitioning::create_additivity_constraints(const OperatorProxy &op, LPConstraints &constraints,
                                                         LPVariables &variables) {
        double operator_cost = op.get_cost();
        int operator_id = op.get_id();
        constraints.emplace_back(-infinity, operator_cost);
        for (const ForkAbstraction &fork_abstraction : fork_abstractions){
            for (const UnaryOperator &unary_operator : fork_abstraction.operators){
                if (unary_operator.original_op_id == operator_id){
                    //Objective_Coefficient = c_i = 0 for all constraints =/= h values
                    //This creates variables with sign constraints
                    vector<int> fork_op_cost_id = {fork_abstraction.root_id, operator_id, unary_operator.effect_id};
                    fork_op_cost_indices[fork_op_cost_id] = variables.size();
                    //changed lower bound from -inf to 0, as else the unary costs of op needed are unbounded...
                    variables.emplace_back(0, infinity, 0, false);
                    /*cout << "Variable ";
                    for (int i: fork_op_cost_id) {
                        cout << i;
                    }
                    cout << " created" << endl;*/
                    //Index = index of variable (w1 abstraction o1 operator a unary effect) coeff = 1 in add constr -1/0 else
                    //variables.push_back(index);
                    //coefficients.push_back(coefficient);
                    //Insert tells which variable of the variable list has which coefficient in this constraint
                    //operator_id + unary_operator.effect_id + fork_abstraction.root_id
                    constraints.back().insert(fork_op_cost_indices[fork_op_cost_id],1);
                }
            }
        }
        /*cout << "Constraint: " << op.get_name() << " <= " << constraints.back().get_upper_bound() << endl;
        cout << "Variables: ";
        for (int var : constraints.back().get_variables()){
            cout << var << ", ";
        }
        cout << endl << "Coefficients: ";
        for (double coeff : constraints.back().get_coefficients()){
            cout << coeff << ", ";
        }
        cout << endl;*/
        /*
         for (ForkAbstraction fork_abstraction : fork_abstractions){
            for (UnaryOperator unary_operator : fork_abstraction.operators){

            }
        }
         */
    }

    void CostPartitioning::create_fixed_root_fork_constraints(const ForkAbstraction &fork_abstraction, const TaskProxy &task_proxy,
                                                              LPConstraints &constraints, LPVariables &variables) {
        for (ForkSuccessor succ : fork_abstraction.successors) {
            int succ_domain_size = task_proxy.get_variables()[succ.var_id].get_domain_size();
            bool succ_is_goal_var = false;
            for (AbstractFact const &goal_var : fork_abstraction.abstract_goal){
                if (goal_var.var_id == succ.var_id){
                    succ_is_goal_var = true;
                    break;
                }
            }//Find better way for this
            if (succ_is_goal_var) {
                //Firsts add all variables
                for (int dom_i = 0; dom_i < succ_domain_size; dom_i++){
                    for (int dom_j = 0; dom_j < succ_domain_size; dom_j++) {
                        for (int root_value = 0; root_value < 2; root_value++) {
                            vector<int> fork_var_id = {fork_abstraction.root_id, succ.var_id, dom_i, dom_j, root_value};
                            fork_var_indices[fork_var_id] = variables.size();
                            variables.emplace_back(-infinity, infinity, 0, false);
                            /*if (dom_i == dom_j) {
                                //p(succ,dom,dom,0/1)
                                //constraints.emplace_back(0, 0);
                                variables.emplace_back(0, 0, 0, false);
                                //constraints.back().insert(variables.size() - 1, 1);
                            } else {
                                //trivial constraints
                                //constraints.emplace_back(-infinity, infinity);
                                variables.emplace_back(-infinity, infinity, 0, false);
                                //constraints.back().insert(variables.size() - 1, 1);
                            }*/
                            /*cout << "Variable " << fork_var_indices[fork_var_id] << " added: ";
                            for (int id : fork_var_id){
                                cout << id;
                            }
                            cout << ", " << variables.back().lower_bound << " <= " << variables.back().upper_bound << endl;*/
                        }
                    }
                }
                //Then add all constraints
                for (int dom_i = 0; dom_i < succ_domain_size; dom_i++){
                    for (int dom_j = 0; dom_j < succ_domain_size; dom_j++) {
                        for (int root_value = 0; root_value < 2; root_value++) {
                            vector<int> fork_var_id = {fork_abstraction.root_id, succ.var_id, dom_i, dom_j, root_value};
                            if (dom_i == dom_j) {
                                //p(succ,dom,dom,0/1)
                                //constraints.emplace_back(0, 0);
                                constraints.emplace_back(0, 0);
                                constraints.back().insert(fork_var_indices[fork_var_id], 1);
                                //constraints.back().insert(variables.size() - 1, 1);
                            } else {
                                //Add all p(succ,dom,dom_2,0/1) constraints not trivial/inf, which are:
                                //p(succ,dom,eff(op)[v],pre(op)[r]_1)
                                //p(succ,dom,eff(op)[v],pre(op)[r]_2)
                                //initially mistakenly added trivial constraints for each unary operator
                                for (UnaryOperator op: fork_abstraction.operators) {
                                    //initially forgot some checks
                                    if (op.effect_id == succ.var_id
                                        && op.unary_effect.value == dom_j
                                        && (op.preconditions.empty()
                                            || op.preconditions.front().var_id != fork_abstraction.root_id
                                            || (op.preconditions.front().var_id == fork_abstraction.root_id
                                                && op.preconditions.front().value == root_value))){
                                        vector<int> fork_op_cost_id = {fork_abstraction.root_id, op.original_op_id,
                                                                       op.effect_id};
                                        //p(succ,dom_i,eff(op)[v],pre(op)[r]) <= wa
                                        constraints.emplace_back(-infinity, 0);
                                        constraints.back().insert(fork_var_indices[fork_var_id], 1);
                                        constraints.back().insert(fork_op_cost_indices[fork_op_cost_id], -1);
                                        if ((!op.preconditions.empty()) && op.preconditions.back().var_id == succ.var_id) {
                                            //Am I sure the operators work always like this?
                                            //p(succ,dom_i,eff(op)[v],pre(op)[r]) <= p(succ,dom_i,pre(op)[v]pre(op)[r]) + wa
                                            vector<int> reaching_pre_var_id
                                                    = {fork_abstraction.root_id, succ.var_id, dom_i,
                                                       op.preconditions.back().value, root_value};
                                            constraints.back().insert(fork_var_indices[reaching_pre_var_id], -1);
                                        }
                                        /*cout << "P Constraint for root " << fork_abstraction.root_id << ": <= "
                                             << constraints.back().get_upper_bound() << endl;
                                        cout << "Wanted Variables: ";
                                        for (int i : fork_var_id) {
                                            cout << i;
                                        }
                                        if (constraints.back().get_variables().size() == 3){
                                            cout << ", ";
                                            for (int i : {fork_abstraction.root_id, succ.var_id, dom_i,
                                                          op.preconditions.back().value, root_value}) {
                                                cout << i;
                                            }
                                        }
                                        cout << ", ";
                                        for (int i : fork_op_cost_id) {
                                            cout << i;
                                        }
                                        cout << endl << "Variables: ";
                                        for (int var : constraints.back().get_variables()) {
                                            cout << var << ", ";
                                        }
                                        cout << endl << "Coefficients: ";
                                        for (double coeff : constraints.back().get_coefficients()) {
                                            cout << coeff << ", ";
                                        }
                                        cout << endl;*/
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    void CostPartitioning::create_root_seq_fork_variables(const ForkAbstraction &fork_abstraction,
                                                         const TaskProxy &task_proxy, LPVariables &variables) {
        //int largest_domain_size = task_proxy.get_variables()[fork_abstraction.root_id].get_domain_size();
        int largest_domain_size = 2;
        for (ForkSuccessor succ : fork_abstraction.successors) {
            int succ_domain_size = task_proxy.get_variables()[succ.var_id].get_domain_size();
            //bool succ_is_goal_var = false;
            for (AbstractFact const &goal_var: fork_abstraction.abstract_goal) {
                if (goal_var.var_id == succ.var_id) {
                    if (succ_domain_size > largest_domain_size) {
                        largest_domain_size = succ_domain_size;
                    }
                    break;
                }
            }
        }
        largest_domain_sizes[fork_abstraction.root_id] = largest_domain_size;

        for (ForkSuccessor succ: fork_abstraction.successors) {
            int succ_domain_size = task_proxy.get_variables()[succ.var_id].get_domain_size();
            bool succ_is_goal_var = false;
            for (AbstractFact const &goal_var: fork_abstraction.abstract_goal) {
                if (goal_var.var_id == succ.var_id) {
                    succ_is_goal_var = true;
                    break;
                }
            }
            if (succ_is_goal_var) {
                for (int root_seq = 1; root_seq <= largest_domain_size + 1; root_seq++) {
                    for (int dom_i = 0; dom_i < succ_domain_size; dom_i++) {
                        vector<int> root_seq_var_id = {fork_abstraction.root_id, succ.var_id, dom_i, root_seq};
                        fork_var_indices[root_seq_var_id] = variables.size();
                        variables.emplace_back(-infinity, infinity, 0, false);
                        /*cout << "D-Variable " << fork_var_indices[root_seq_var_id] << " added: ";
                        for (int id : root_seq_var_id){
                            cout << id;
                        }
                        cout << ", " << variables.back().lower_bound << " <= " << variables.back().upper_bound << endl;*/
                    }
                }
            }
        }
    }

    bool CostPartitioning::update_constraints(
            const State &state, LPSolver &lp_solver) {
        //add temporary constraints
        //LPConstraints temp_constraints;
        //LPVariables temp_variables;
        vector<lp::LPConstraint> temp_constraints;
        //cout << "DOING SOMETHING " << fork_abstractions.size() << endl;
        //cout << "INFINITY " << infinity << endl;
        for (ForkAbstraction const &fork_abstraction : fork_abstractions){
            create_temporary_fork_constraints(state, fork_abstraction, temp_constraints);
            //temp_constraints = temp_fork_constraints.first;
            //temp_variables = temp_fork_constraints.second;
        }
        /*cout << endl;
        cout << temp_variables.size() << " Temporary Variables:" << endl;
        for (LPVariable lpvar : temp_variables){
            cout << lpvar.lower_bound << "<=" << lpvar.upper_bound << ", obj_coeff:" << lpvar.objective_coefficient << endl;
        }
        cout << endl;*/
        //cout << "Size of temp_constraints: " << temp_constraints.size() << endl;
        lp_solver.add_temporary_constraints(temp_constraints);
        return false;
    }

    void CostPartitioning::create_temporary_fork_constraints(const State &state, const ForkAbstraction &fork_abstraction,
                                                             vector<lp::LPConstraint> &temp_constraints) {
        //unordered_map<vector<int>, int, VectorHash> temp_var_indices;
        TaskProxy task_proxy = state.get_task();
        int largest_domain_size = largest_domain_sizes[fork_abstraction.root_id];
        //FactProxy fact1 = state[fork_abstraction.root_id];
        //VariableProxy var1 = task_proxy.get_variables()[fork_abstraction.variables.front()];
        //FactProxy fact2 = state[var1];
        /*int largest_domain_size = task_proxy.get_variables()[fork_abstraction.root_id].get_domain_size();
        for (ForkSuccessor succ : fork_abstraction.successors) {
            int succ_domain_size = task_proxy.get_variables()[succ.var_id].get_domain_size();
            for (AbstractFact const &goal_var: fork_abstraction.abstract_goal) {
                if (goal_var.var_id == succ.var_id) {
                    if (succ_domain_size > largest_domain_size) {
                        largest_domain_size = succ_domain_size;
                        succ_is_goal_var = true;
                    }
                    break;
                }
            }

        }*/
        int initial_root_value = fork_abstraction.root_dom_mapping[state[fork_abstraction.root_id].get_value()];//0 or 1
        vector<int> root_sequence;
        root_sequence.reserve(largest_domain_size + 1);
        int root_value = initial_root_value;
        for (int i = 0; i < largest_domain_size + 1; i++) {
            root_sequence.emplace_back(root_value);
            root_value = 1 - root_value;
        }
        //cout << "creating temporary constraints with largest domain size: " << largest_domain_size << endl;
        //Creating d constraints
        for (ForkSuccessor succ: fork_abstraction.successors) {
            int succ_domain_size = task_proxy.get_variables()[succ.var_id].get_domain_size();
            bool succ_is_goal_var = false;
            for (AbstractFact const &goal_var: fork_abstraction.abstract_goal) {
                if (goal_var.var_id == succ.var_id) {
                    succ_is_goal_var = true;
                    break;
                }
            }//Find better way for this
            if (succ_is_goal_var) {
                for (int dom_i = 0; dom_i < succ_domain_size; dom_i++) {
                    //d(succ,dom_i,1) <= p(succ,s[succ],dom_i,root_seq[1])
                    //temp_var_indices[temp_var_id] = variables.size() + temp_variables.size();
                    //temp_variables.emplace_back(-infinity, infinity, 0, false);
                    temp_constraints.emplace_back(-infinity, 0);
                    vector<int> root_seq_var = {fork_abstraction.root_id, succ.var_id, dom_i, 1};
                    vector<int> fixed_root_var = {fork_abstraction.root_id, succ.var_id,
                                                  state[succ.var_id].get_value(), dom_i, initial_root_value};
                    temp_constraints.back().insert(fork_var_indices[root_seq_var], 1);
                    temp_constraints.back().insert(fork_var_indices[fixed_root_var], -1);
                    /*cout << "D Constraint for root " << fork_abstraction.root_id << ": <= "
                         << temp_constraints.back().get_upper_bound() << endl;
                    cout << "Wanted Variables: ";
                    for (int i : root_seq_var) {
                        cout << i;
                    }
                    cout << ", ";
                    for (int i : fixed_root_var) {
                        cout << i;
                    }
                    cout << endl << "Variables: ";
                    for (int var : temp_constraints.back().get_variables()) {
                        cout << var << ", ";
                    }
                    cout << endl << "Coefficients: ";
                    for (double coeff : temp_constraints.back().get_coefficients()) {
                        cout << coeff << ", ";
                    }
                    cout << endl;*/
                }
                //TODO Maybe take out the root sequences that are unachievable and thus will not be used in h
                for (int root_seq = 2; root_seq <= largest_domain_size + 1; root_seq++) {
                    for (int dom_i = 0; dom_i < succ_domain_size; dom_i++) {
                        vector<int> root_seq_var = {fork_abstraction.root_id, succ.var_id, dom_i, root_seq};
                        //temp_var_indices[temp_var_id] = variables.size() + temp_variables.size();
                        //temp_variables.emplace_back(-infinity, infinity, 0, false);
                        for (int dom_j = 0; dom_j < succ_domain_size; dom_j++) {
                            //should be indexed in right order s.t. pre_var_id is already created
                            //no longer matters as all variables already indexed
                            //d(succ,dom_i,i) <= d(succ,dom_j,i-1) + p(succ,dom_j,dom_i,root_seq[i])
                            temp_constraints.emplace_back(-infinity, 0);
                            vector<int> pre_var_id = {fork_abstraction.root_id, succ.var_id, dom_j, root_seq - 1};
                            vector<int> fixed_root_var = {fork_abstraction.root_id, succ.var_id, dom_j, dom_i,
                                                          root_sequence[root_seq - 1]};
                            temp_constraints.back().insert(fork_var_indices[root_seq_var], 1);
                            temp_constraints.back().insert(fork_var_indices[pre_var_id], -1);
                            temp_constraints.back().insert(fork_var_indices[fixed_root_var], -1);
                            /*cout << "D Constraint for root " << fork_abstraction.root_id << ": <= "
                                 << temp_constraints.back().get_upper_bound() << endl;
                            cout << "Wanted Variables: ";
                            for (int i : root_seq_var) {
                                cout << i;
                            }
                            cout << ", ";
                            for (int i : pre_var_id) {
                                cout << i;
                            }
                            cout << ", ";
                            for (int i : fixed_root_var) {
                                cout << i;
                            }
                            cout << endl << "Variables: ";
                            for (int var : temp_constraints.back().get_variables()) {
                                cout << var << ", ";
                            }
                            cout << endl << "Coefficients: ";
                            for (double coeff : temp_constraints.back().get_coefficients()) {
                                cout << coeff << ", ";
                            }
                            cout << endl;*/
                        }
                    }
                }
            }
        }
        create_h_constraints(root_sequence, fork_abstraction, temp_constraints);
    }

    void CostPartitioning::create_h_constraints(vector<int> &root_sequence,
                                                const implicit::ForkAbstraction &fork_abstraction,
                                                vector<lp::LPConstraint> &temp_constraints) {
        //Creating h constraints
        //temp_var_indices[{fork_abstraction.root_id}] = variables.size() + temp_variables.size();
        //temp_variables.emplace_back(-infinity, infinity, 1, false);
        /*cout << endl << "H-Variable " << temp_var_indices[{fork_abstraction.root_id}] << " added: ";
        for (int id : {fork_abstraction.root_id}){
            cout << id;
        }
        cout << endl;*/
        bool root_is_specified_in_goal = false;
        if ((!fork_abstraction.abstract_goal.empty())
            && fork_abstraction.abstract_goal.front().var_id == fork_abstraction.root_id) {
            root_is_specified_in_goal = true;
        }
        vector<UnaryOperator> changing_root_to_zero;
        vector<UnaryOperator> changing_root_to_one;
        for (UnaryOperator const &op : fork_abstraction.operators) {
            if (op.effect_id == fork_abstraction.root_id){
                if (op.unary_effect.value == 0) {
                    //cout << "operator changing root to 0 found"  << endl;
                    changing_root_to_zero.emplace_back(op);
                } else {
                    assert(op.unary_effect.value == 1);
                    //cout << "operator changing root to 1 found" << endl;
                    changing_root_to_one.emplace_back(op);
                }
            }
        }
        int initial_root_value = root_sequence[0];
        //TODO do this without partial root seq
        vector<int> partial_root_sequence;
        partial_root_sequence.reserve(root_sequence.size());
        //TODO find a way to make h constraints without copying similar code 6(8)->3(4) times (Cases with 0 op0, 0 op1, other)
        for (int r_value : root_sequence) {
            partial_root_sequence.emplace_back(r_value);
            int root_seq_size = (int)partial_root_sequence.size();
            /*cout << endl << "new partial root sequence " ;
            for (int i : partial_root_sequence) {
                cout << i;
            }
            cout << endl;*/
            if (root_is_specified_in_goal && fork_abstraction.abstract_goal.front().value != r_value) {
                //cout << "is not a goal achieving sequence" << endl;
                continue;
            } else {
                assert((root_is_specified_in_goal && fork_abstraction.abstract_goal.front().value == r_value) ||
                       !root_is_specified_in_goal);
                //cout << "goal achieving sequence" << endl;
                //Is there a better way to do this?
                //TODO add goal variables and maybe better way for creating constraints when 0 op0 and 0 op1 (check if temp constraints have correct p indices)
                if (changing_root_to_zero.empty()) {
                    if (changing_root_to_one.empty()){
                        //cout << "no root changing operators" << endl;
                        temp_constraints.emplace_back(-infinity, 0);
                        temp_constraints.back().insert(fork_var_indices[{fork_abstraction.root_id}], 1);
                        //add goal variables
                        add_goal_var_constraints(root_seq_size, fork_abstraction, temp_constraints);
                        /*for (ForkSuccessor succ : fork_abstraction.successors) {
                            for (AbstractFact const &goal_var: fork_abstraction.abstract_goal) {
                                if (goal_var.var_id == succ.var_id) {
                                    vector<int> goal_val_root_seq = {fork_abstraction.root_id, succ.var_id, goal_var.value,
                                                                     static_cast<int>(partial_root_sequence.size())};
                                    temp_constraints.back().insert(fork_var_indices[goal_val_root_seq], -1);
                                    break;
                                }
                            }
                        }*/
                        /*cout << "H Constraint for root " << fork_abstraction.root_id << ": <= "
                             << temp_constraints.back().get_upper_bound() << endl;
                        cout << "Wanted Variables: ";
                        cout << fork_abstraction.root_id << ", ";
                        cout << endl << "Variables: ";
                        for (int var : temp_constraints.back().get_variables()) {
                            cout << var << ", ";
                        }
                        cout << endl << "Coefficients: ";
                        for (double coeff : temp_constraints.back().get_coefficients()) {
                            cout << coeff << ", ";
                        }
                        cout << endl;
                        cout << "no more root sequences possible as we cannot change the root" << endl << endl;*/
                        break;
                    } else {
                        assert(changing_root_to_zero.empty());
                        assert(!changing_root_to_one.empty());
                        for (const UnaryOperator &op1: changing_root_to_one) {
                            //cout << "op1" << endl;
                            vector<int> op1_ind = {fork_abstraction.root_id, op1.original_op_id, op1.effect_id};
                            temp_constraints.emplace_back(-infinity, 0);
                            temp_constraints.back().insert(fork_var_indices[{fork_abstraction.root_id}], 1);
                            if (initial_root_value == 0) { //-> 1 once more often than 0 effect
                                temp_constraints.back().insert(fork_op_cost_indices[op1_ind],
                                                               -ceil(static_cast<float>(root_seq_size - 1) /2));
                            } else {
                                assert(initial_root_value == 1);
                                temp_constraints.back().insert(fork_op_cost_indices[op1_ind],
                                                               -floor(static_cast<float>(root_seq_size - 1) /2));
                            }
                            //add goal variables
                            add_goal_var_constraints(root_seq_size, fork_abstraction, temp_constraints);
                            /*for (ForkSuccessor succ : fork_abstraction.successors) {
                                for (AbstractFact const &goal_var: fork_abstraction.abstract_goal) {
                                    if (goal_var.var_id == succ.var_id) {
                                        vector<int> goal_val_root_seq = {fork_abstraction.root_id, succ.var_id, goal_var.value,
                                                                         static_cast<int>(partial_root_sequence.size())};
                                        temp_constraints.back().insert(fork_var_indices[goal_val_root_seq], -1);
                                        break;
                                    }
                                }
                            }*/
                            /*cout << "H Constraint for root " << fork_abstraction.root_id << ": <= "
                                 << temp_constraints.back().get_upper_bound() << endl;
                            cout << "Wanted Variables: ";
                            cout << fork_abstraction.root_id << ", ";
                            for (int i: op1_ind) {
                                cout << i;
                            }
                            cout << endl << "Variables: ";
                            for (int var: temp_constraints.back().get_variables()) {
                                cout << var << ", ";
                            }
                            cout << endl << "Coefficients: ";
                            for (double coeff: temp_constraints.back().get_coefficients()) {
                                cout << coeff << ", ";
                            }
                            cout << endl;*/
                        }
                    }
                    if (r_value == 1) {
                        //cout << "no more root sequences possible as we cannot set root to 0" << endl << endl;
                        break;
                    }
                } else {
                    assert(!changing_root_to_zero.empty());
                    if (changing_root_to_one.empty()) {
                        for (UnaryOperator const &op0: changing_root_to_zero) {
                            //cout << "op0" << endl;
                            vector<int> op0_ind = {fork_abstraction.root_id, op0.original_op_id, op0.effect_id};
                            temp_constraints.emplace_back(-infinity, 0);
                            temp_constraints.back().insert(fork_var_indices[{fork_abstraction.root_id}], 1);
                            if (initial_root_value == 0) { //-> 1 once more often than 0 effect
                                temp_constraints.back().insert(fork_op_cost_indices[op0_ind],
                                                               -floor(static_cast<float>(root_seq_size - 1) /2));
                            } else {
                                assert(initial_root_value == 1);
                                temp_constraints.back().insert(fork_op_cost_indices[op0_ind],
                                                               -ceil(static_cast<float>(root_seq_size - 1) /2));
                            }
                            //add goal variables
                            add_goal_var_constraints(root_seq_size, fork_abstraction, temp_constraints);
                            /*for (ForkSuccessor succ : fork_abstraction.successors) {
                                for (AbstractFact const &goal_var: fork_abstraction.abstract_goal) {
                                    if (goal_var.var_id == succ.var_id) {
                                        vector<int> goal_val_root_seq = {fork_abstraction.root_id, succ.var_id, goal_var.value,
                                                                         static_cast<int>(partial_root_sequence.size())};
                                        temp_constraints.back().insert(fork_var_indices[goal_val_root_seq], -1);
                                        break;
                                    }
                                }
                            }*/
                            /*cout << "H Constraint for root " << fork_abstraction.root_id << ": <= "
                                 << temp_constraints.back().get_upper_bound() << endl;
                            cout << "Wanted Variables: ";
                            cout << fork_abstraction.root_id << ", ";
                            for (int i: op0_ind) {
                                cout << i;
                            }
                            cout << ", ";
                            cout << endl << "Variables: ";
                            for (int var: temp_constraints.back().get_variables()) {
                                cout << var << ", ";
                            }
                            cout << endl << "Coefficients: ";
                            for (double coeff: temp_constraints.back().get_coefficients()) {
                                cout << coeff << ", ";
                            }
                            cout << endl;*/
                        }
                        if (r_value == 0) {
                            //cout << "no more root sequences possible as we cannot set root to 1" << endl << endl;
                            break;
                        }
                    } else {
                        assert(!changing_root_to_zero.empty());
                        assert(!changing_root_to_one.empty());
                        for (UnaryOperator const &op0: changing_root_to_zero) {
                            //cout << "op0" << endl;
                            for (UnaryOperator const &op1: changing_root_to_one) {
                                //cout << "op1" << endl;
                                vector<int> op0_ind = {fork_abstraction.root_id, op0.original_op_id, op0.effect_id};
                                vector<int> op1_ind = {fork_abstraction.root_id, op1.original_op_id, op1.effect_id};
                                temp_constraints.emplace_back(-infinity, 0);
                                temp_constraints.back().insert(fork_var_indices[{fork_abstraction.root_id}], 1);
                                if (initial_root_value == 0) { //-> 1 once more often than 0 effect
                                    temp_constraints.back().insert(fork_op_cost_indices[op0_ind],
                                                                   -floor(static_cast<float>(root_seq_size - 1) /2));
                                    temp_constraints.back().insert(fork_op_cost_indices[op1_ind],
                                                                   -ceil(static_cast<float>(root_seq_size - 1) /2));
                                } else {
                                    assert(initial_root_value == 1);
                                    temp_constraints.back().insert(fork_op_cost_indices[op0_ind],
                                                                   -ceil(static_cast<float>(root_seq_size - 1) /2));
                                    temp_constraints.back().insert(fork_op_cost_indices[op1_ind],
                                                                   -floor(static_cast<float>(root_seq_size - 1) /2));
                                }
                                //add goal variables
                                add_goal_var_constraints(root_seq_size, fork_abstraction, temp_constraints);
                                /*for (ForkSuccessor succ : fork_abstraction.successors) {
                                    for (AbstractFact const &goal_var: fork_abstraction.abstract_goal) {
                                        if (goal_var.var_id == succ.var_id) {
                                            vector<int> goal_val_root_seq = {fork_abstraction.root_id, succ.var_id, goal_var.value,
                                                                             static_cast<int>(partial_root_sequence.size())};
                                            temp_constraints.back().insert(fork_var_indices[goal_val_root_seq], -1);
                                            break;
                                        }
                                    }
                                }*/
                                /*cout << "H Constraint for root " << fork_abstraction.root_id << ": <= "
                                     << temp_constraints.back().get_upper_bound() << endl;
                                cout << "Wanted Variables: ";
                                cout << fork_abstraction.root_id << ", ";
                                for (int i: op0_ind) {
                                    cout << i;
                                }
                                cout << ", ";
                                for (int i: op1_ind) {
                                    cout << i;
                                }
                                cout << endl << "Variables: ";
                                for (int var: temp_constraints.back().get_variables()) {
                                    cout << var << ", ";
                                }
                                cout << endl << "Coefficients: ";
                                for (double coeff: temp_constraints.back().get_coefficients()) {
                                    cout << coeff << ", ";
                                }
                                cout << endl;*/
                            }
                        }
                    }
                }
            }
        }
    }

    void CostPartitioning::add_goal_var_constraints(int root_seq_size, const ForkAbstraction &fork_abstraction,
                                                           vector<lp::LPConstraint> &temp_constraints) {
        for (ForkSuccessor succ : fork_abstraction.successors) {
            for (AbstractFact const &goal_var: fork_abstraction.abstract_goal) {
                if (goal_var.var_id == succ.var_id) {
                    vector<int> goal_val_root_seq = {fork_abstraction.root_id, succ.var_id, goal_var.value,
                                                     root_seq_size};
                    temp_constraints.back().insert(fork_var_indices[goal_val_root_seq], -1);
                    /*cout << "goal_val_id " ;
                    for (int i: goal_val_root_seq) {
                        cout << i;
                    }
                    cout << endl;*/
                    break;
                }
            }
        }
    }

    void CostPartitioning::dump_variables(LPVariables &variables) {
        cout << endl;
        cout << variables.size() << " LPVariables:" << endl;
        for (LPVariable lpvar: variables) {
            cout << lpvar.lower_bound << "<=" << lpvar.upper_bound << ", obj_coeff:" << lpvar.objective_coefficient
                 << endl;
        }
        cout << endl;
    }
}